/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.preference;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.APRIORI;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.HashmapDatabase;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.datasource.bundle.SingleObjectBundle;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.OnedimensionalDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.AbstractPreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.PreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.result.FrequentItemsetsResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.exceptions.EmptyDataException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Description(value="Computes the preference vector of objects of a certain database according to the DiSH algorithm.")
public class DiSHPreferenceVectorIndex<V extends NumberVector>
extends AbstractPreferenceVectorIndex<V>
implements PreferenceVectorIndex<V> {
    private static final Logging LOG = Logging.getLogger(DiSHPreferenceVectorIndex.class);
    protected double[] epsilon;
    protected int minpts;
    protected Strategy strategy;

    public DiSHPreferenceVectorIndex(Relation<V> relation, double[] epsilon, int minpts, Strategy strategy) {
        super(relation);
        this.epsilon = epsilon;
        this.minpts = minpts;
        this.strategy = strategy;
    }

    @Override
    public void initialize() {
        if (this.relation == null || this.relation.size() == 0) {
            throw new EmptyDataException();
        }
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, long[].class);
        if (LOG.isDebugging()) {
            LOG.debugFine("eps " + Arrays.asList(new double[][]{this.epsilon}) + "\n minpts " + this.minpts + "\n strategy " + (Object)((Object)this.strategy));
        }
        long start = System.currentTimeMillis();
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Preprocessing preference vector", this.relation.size(), LOG) : null;
        int dim = RelationUtil.dimensionality(this.relation);
        if (this.epsilon.length == 1 && dim != 1) {
            double eps = this.epsilon[0];
            this.epsilon = new double[dim];
            Arrays.fill(this.epsilon, eps);
        }
        RangeQuery<V>[] rangeQueries = this.initRangeQueries(this.relation, dim);
        StringBuilder msg = LOG.isDebugging() ? new StringBuilder() : null;
        DBIDIter it = this.relation.iterDBIDs();
        while (it.valid()) {
            int d;
            if (msg != null) {
                msg.setLength(0);
                msg.append("\nid = ").append(DBIDUtil.toString(it));
            }
            ModifiableDBIDs[] allNeighbors = new ModifiableDBIDs[dim];
            for (d = 0; d < dim; ++d) {
                allNeighbors[d] = DBIDUtil.newHashSet(rangeQueries[d].getRangeForDBID(it, this.epsilon[d]));
            }
            if (msg != null) {
                for (d = 0; d < dim; ++d) {
                    msg.append("\n neighbors [").append(d).append(']').append(" (").append(allNeighbors[d].size()).append(") = ").append(allNeighbors[d]);
                }
            }
            this.storage.put(it, this.determinePreferenceVector(this.relation, allNeighbors, msg));
            if (msg != null) {
                LOG.debugFine(msg.toString());
            }
            LOG.incrementProcessed(progress);
            it.advance();
        }
        LOG.ensureCompleted(progress);
        if (LOG.isVerbose()) {
            long end = System.currentTimeMillis();
            long elapsedTime = end - start;
            LOG.verbose(this.getClass().getName() + " runtime: " + elapsedTime + " milliseconds.");
        }
    }

    private long[] determinePreferenceVector(Relation<V> relation, ModifiableDBIDs[] neighborIDs, StringBuilder msg) {
        if (this.strategy.equals((Object)Strategy.APRIORI)) {
            return this.determinePreferenceVectorByApriori(relation, neighborIDs, msg);
        }
        if (this.strategy.equals((Object)Strategy.MAX_INTERSECTION)) {
            return this.determinePreferenceVectorByMaxIntersection(neighborIDs, msg);
        }
        throw new IllegalStateException("Should never happen!");
    }

    private long[] determinePreferenceVectorByApriori(Relation<V> relation, ModifiableDBIDs[] neighborIDs, StringBuilder msg) {
        int dimensionality = neighborIDs.length;
        HashmapDatabase apriori_db = new HashmapDatabase();
        VectorFieldTypeInformation<BitVector> bitmeta = VectorFieldTypeInformation.typeRequest(BitVector.class, dimensionality, dimensionality);
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            long[] bits = BitsUtil.zero(dimensionality);
            boolean allFalse = true;
            for (int d = 0; d < dimensionality; ++d) {
                if (!neighborIDs[d].contains(it)) continue;
                BitsUtil.setI(bits, d);
                allFalse = false;
            }
            if (!allFalse) {
                SingleObjectBundle oaa = new SingleObjectBundle();
                oaa.append(bitmeta, new BitVector(bits, dimensionality));
                apriori_db.insert(oaa);
            }
            it.advance();
        }
        APRIORI apriori = new APRIORI(this.minpts);
        FrequentItemsetsResult aprioriResult = (FrequentItemsetsResult)apriori.run(apriori_db);
        List<Itemset> frequentItemsets = aprioriResult.getItemsets();
        if (msg != null) {
            msg.append("\n Frequent itemsets: ").append(frequentItemsets);
        }
        int maxSupport = 0;
        int maxCardinality = 0;
        long[] preferenceVector = BitsUtil.zero(dimensionality);
        for (Itemset itemset : frequentItemsets) {
            if (maxCardinality >= itemset.length() && (maxCardinality != itemset.length() || maxSupport != itemset.getSupport())) continue;
            preferenceVector = Itemset.toBitset(itemset, BitsUtil.zero(dimensionality));
            maxCardinality = itemset.length();
            maxSupport = itemset.getSupport();
        }
        if (msg != null) {
            msg.append("\n preference ").append(BitsUtil.toStringLow(preferenceVector, dimensionality)).append('\n');
            LOG.debugFine(msg.toString());
        }
        return preferenceVector;
    }

    private long[] determinePreferenceVectorByMaxIntersection(ModifiableDBIDs[] neighborIDs, StringBuilder msg) {
        int i;
        int dimensionality = neighborIDs.length;
        long[] preferenceVector = BitsUtil.zero(dimensionality);
        HashMap<Integer, ModifiableDBIDs> candidates = new HashMap<Integer, ModifiableDBIDs>(dimensionality);
        for (i = 0; i < dimensionality; ++i) {
            ModifiableDBIDs s_i = neighborIDs[i];
            if (s_i.size() <= this.minpts) continue;
            candidates.put(i, s_i);
        }
        if (msg != null) {
            msg.append("\n candidates ").append(candidates.keySet());
        }
        if (!candidates.isEmpty()) {
            i = this.max(candidates);
            ModifiableDBIDs intersection = (ModifiableDBIDs)candidates.remove(i);
            BitsUtil.setI(preferenceVector, i);
            while (!candidates.isEmpty()) {
                i = this.maxIntersection(candidates, intersection);
                candidates.remove(i);
                if (intersection.size() < this.minpts) break;
                BitsUtil.setI(preferenceVector, i);
            }
        }
        if (msg != null) {
            msg.append("\n preference ").append(BitsUtil.toStringLow(preferenceVector, dimensionality));
            LOG.debug(msg.toString());
        }
        return preferenceVector;
    }

    private int max(Map<Integer, ModifiableDBIDs> candidates) {
        int maxDim = -1;
        int size = -1;
        for (Integer nextDim : candidates.keySet()) {
            int nextSet = candidates.get(nextDim).size();
            if (size >= nextSet) continue;
            size = nextSet;
            maxDim = nextDim;
        }
        return maxDim;
    }

    private int maxIntersection(Map<Integer, ModifiableDBIDs> candidates, ModifiableDBIDs set) {
        int maxDim = -1;
        DBIDs maxIntersection = null;
        for (Integer nextDim : candidates.keySet()) {
            DBIDs nextSet = candidates.get(nextDim);
            ModifiableDBIDs nextIntersection = DBIDUtil.intersection(set, nextSet);
            if (maxDim >= 0 && maxIntersection.size() >= nextIntersection.size()) continue;
            maxIntersection = nextIntersection;
            maxDim = nextDim;
        }
        if (maxDim >= 0) {
            set.clear();
            set.addDBIDs(maxIntersection);
        }
        return maxDim;
    }

    private RangeQuery<V>[] initRangeQueries(Relation<V> relation, int dimensionality) {
        RangeQuery[] rangeQueries = new RangeQuery[dimensionality];
        for (int d = 0; d < dimensionality; ++d) {
            rangeQueries[d] = relation.getRangeQuery(new PrimitiveDistanceQuery<NumberVector>(relation, new OnedimensionalDistanceFunction(d)), new Object[0]);
        }
        return rangeQueries;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "DiSH Preference Vectors";
    }

    @Override
    public String getShortName() {
        return "dish-pref";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<V extends NumberVector>
    extends AbstractPreferenceVectorIndex.Factory<V> {
        public static final double DEFAULT_EPSILON = 0.001;
        public static final OptionID EPSILON_ID = new OptionID("dish.epsilon", "A comma separated list of positive doubles specifying the maximum radius of the neighborhood to be considered in each dimension for determination of the preference vector (default is 0.001 in each dimension). If only one value is specified, this value will be used for each dimension.");
        public static final String MINPTS_P = "dish.minpts";
        private static final String CONDITION = "The value of the preference vector in dimension d_i is set to 1 if the epsilon neighborhood contains more than dish.minpts points and the following condition holds: for all dimensions d_j: |neighbors(d_i) intersection neighbors(d_j)| >= dish.minpts.";
        public static final OptionID MINPTS_ID = new OptionID("dish.minpts", "Positive threshold for minumum numbers of points in the epsilon-neighborhood of a point. The value of the preference vector in dimension d_i is set to 1 if the epsilon neighborhood contains more than dish.minpts points and the following condition holds: for all dimensions d_j: |neighbors(d_i) intersection neighbors(d_j)| >= dish.minpts.");
        public static final Strategy DEFAULT_STRATEGY = Strategy.MAX_INTERSECTION;
        public static final OptionID STRATEGY_ID = new OptionID("dish.strategy", "The strategy for determination of the preference vector, available strategies are: [" + (Object)((Object)Strategy.APRIORI) + "| " + (Object)((Object)Strategy.MAX_INTERSECTION) + "](default is " + (Object)((Object)DEFAULT_STRATEGY) + ")");
        protected double[] epsilon;
        protected int minpts;
        protected Strategy strategy;

        public Factory(double[] epsilon, int minpts, Strategy strategy) {
            this.epsilon = epsilon;
            this.minpts = minpts;
            this.strategy = strategy;
        }

        @Override
        public DiSHPreferenceVectorIndex<V> instantiate(Relation<V> relation) {
            return new DiSHPreferenceVectorIndex<V>(relation, this.epsilon, this.minpts, this.strategy);
        }

        public int getMinpts() {
            return this.minpts;
        }

        public static class Parameterizer<V extends NumberVector>
        extends AbstractParameterizer {
            protected double[] epsilon;
            protected int minpts;
            protected Strategy strategy;

            @Override
            protected void makeOptions(Parameterization config) {
                EnumParameter<Strategy> strategyP;
                DoubleListParameter epsilonP;
                super.makeOptions(config);
                IntParameter minptsP = (IntParameter)new IntParameter(MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (config.grab(minptsP)) {
                    this.minpts = (Integer)minptsP.getValue();
                }
                if (config.grab(epsilonP = (DoubleListParameter)((DoubleListParameter)new DoubleListParameter(EPSILON_ID, true).setDefaultValue(new double[]{0.001})).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE_LIST))) {
                    this.epsilon = (double[])((double[])epsilonP.getValue()).clone();
                }
                if (config.grab(strategyP = new EnumParameter<Strategy>(STRATEGY_ID, Strategy.class, DEFAULT_STRATEGY))) {
                    this.strategy = (Strategy)((Object)strategyP.getValue());
                }
            }

            @Override
            protected Factory<V> makeInstance() {
                return new Factory(this.epsilon, this.minpts, this.strategy);
            }
        }
    }

    public static enum Strategy {
        APRIORI,
        MAX_INTERSECTION;

    }
}

