/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.preference;

import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.HiSC;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.AbstractPreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.preference.PreferenceVectorIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.EmptyDataException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="HiSC Preprocessor")
@Description(value="Computes the preference vector of objects of a certain database according to the HiSC algorithm.")
@Reference(authors="Elke Achtert, Christian B\u00f6hm, Hans-Petre Kriegel, Peer Kr\u00f6ger, Ina M\u00fcller-Gorman, Arthur Zimek", title="Finding Hierarchies of Subspace Clusters", booktitle="Proc. 10th Europ. Conf. on Principles and Practice of Knowledge Discovery in Databases (PKDD'06)", url="https://doi.org/10.1007/11871637_42", bibkey="DBLP:conf/pkdd/AchtertBKKMZ06")
public class HiSCPreferenceVectorIndex<V extends NumberVector>
extends AbstractPreferenceVectorIndex<V>
implements PreferenceVectorIndex<V> {
    private static final Logging LOG = Logging.getLogger(HiSCPreferenceVectorIndex.class);
    protected double alpha;
    protected int k;

    public HiSCPreferenceVectorIndex(Relation<V> relation, double alpha, int k) {
        super(relation);
        this.alpha = alpha;
        this.k = k;
    }

    @Override
    public void initialize() {
        if (this.relation == null || this.relation.size() <= 0) {
            throw new EmptyDataException();
        }
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, long[].class);
        KNNQuery<NumberVector> knnQuery = QueryUtil.getKNNQuery(this.relation, EuclideanDistanceFunction.STATIC, this.k);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Preprocessing preference vector", this.relation.size(), LOG) : null;
        long start = System.currentTimeMillis();
        DBIDIter it = this.relation.iterDBIDs();
        while (it.valid()) {
            this.storage.put(it, this.determinePreferenceVector(this.relation, it, knnQuery.getKNNForDBID(it, this.k)));
            LOG.incrementProcessed(progress);
            it.advance();
        }
        LOG.ensureCompleted(progress);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.getClass().getName() + ".runtime.ms", System.currentTimeMillis() - start));
        }
    }

    private long[] determinePreferenceVector(Relation<V> relation, DBIDRef id, DBIDs neighborIDs) {
        NumberVector p = (NumberVector)relation.get(id);
        int size = neighborIDs.size();
        int dim = p.getDimensionality();
        double[] sumsq = new double[dim];
        DBIDIter iter = neighborIDs.iter();
        while (iter.valid()) {
            NumberVector o = (NumberVector)relation.get(iter);
            int d = 0;
            while (d < dim) {
                double diff = o.doubleValue(d) - p.doubleValue(d);
                int n = d++;
                sumsq[n] = sumsq[n] + diff * diff;
            }
            iter.advance();
        }
        long[] preferenceVector = BitsUtil.zero(dim);
        for (int d = 0; d < dim; ++d) {
            if (!(sumsq[d] < this.alpha * (double)size)) continue;
            BitsUtil.setI(preferenceVector, d);
        }
        return preferenceVector;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "HiSC Preference Vectors";
    }

    @Override
    public String getShortName() {
        return "hisc-pref";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<V extends NumberVector>
    extends AbstractPreferenceVectorIndex.Factory<V> {
        protected double alpha;
        protected int k;

        public Factory(double alpha, int k) {
            this.alpha = alpha;
            this.k = k;
        }

        public double getAlpha() {
            return this.alpha;
        }

        @Override
        public HiSCPreferenceVectorIndex<V> instantiate(Relation<V> relation) {
            int usek = this.k > 0 ? this.k : 3 * RelationUtil.dimensionality(relation);
            return new HiSCPreferenceVectorIndex<V>(relation, this.alpha, usek);
        }

        public static class Parameterizer<V extends NumberVector>
        extends AbstractParameterizer {
            protected double alpha;
            protected int k = 0;

            @Override
            protected void makeOptions(Parameterization config) {
                IntParameter kP;
                super.makeOptions(config);
                DoubleParameter alphaP = (DoubleParameter)((DoubleParameter)new DoubleParameter(HiSC.Parameterizer.ALPHA_ID, 0.01).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE);
                if (config.grab(alphaP)) {
                    this.alpha = alphaP.doubleValue();
                }
                if (config.grab(kP = (IntParameter)((IntParameter)new IntParameter(HiSC.Parameterizer.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).setOptional(true))) {
                    this.k = kP.intValue();
                }
            }

            @Override
            protected Factory<V> makeInstance() {
                return new Factory(this.alpha, this.k);
            }
        }
    }
}

