/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.snn;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.AbstractPreprocessorIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.snn.SharedNearestNeighborIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="Shared Nearest Neighbor Preprocessor")
@Description(value="Computes the k nearest neighbors of objects of a certain database.")
public class SharedNearestNeighborPreprocessor<O>
extends AbstractPreprocessorIndex<O, ArrayDBIDs>
implements SharedNearestNeighborIndex<O> {
    private static final Logging LOG = Logging.getLogger(SharedNearestNeighborPreprocessor.class);
    protected int numberOfNeighbors;
    protected DistanceFunction<O> distanceFunction;

    public SharedNearestNeighborPreprocessor(Relation<O> relation, int numberOfNeighbors, DistanceFunction<O> distanceFunction) {
        super(relation);
        this.numberOfNeighbors = numberOfNeighbors;
        this.distanceFunction = distanceFunction;
    }

    @Override
    public void initialize() {
        if (this.getLogger().isVerbose()) {
            this.getLogger().verbose("Assigning nearest neighbor lists to database objects");
        }
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, ArrayDBIDs.class);
        KNNQuery<O> knnquery = QueryUtil.getKNNQuery(this.relation, this.distanceFunction, this.numberOfNeighbors);
        FiniteProgress progress = this.getLogger().isVerbose() ? new FiniteProgress("assigning nearest neighbor lists", this.relation.size(), this.getLogger()) : null;
        DBIDIter iditer = this.relation.iterDBIDs();
        while (iditer.valid()) {
            ArrayModifiableDBIDs neighbors = DBIDUtil.newArray(this.numberOfNeighbors);
            KNNList kNN = knnquery.getKNNForDBID(iditer, this.numberOfNeighbors);
            DBIDIter iter = kNN.iter();
            while (iter.valid()) {
                neighbors.add(iter);
                if (neighbors.size() >= this.numberOfNeighbors) break;
                iter.advance();
            }
            neighbors.sort();
            this.storage.put(iditer, neighbors);
            this.getLogger().incrementProcessed(progress);
            iditer.advance();
        }
        this.getLogger().ensureCompleted(progress);
    }

    @Override
    public ArrayDBIDs getNearestNeighborSet(DBIDRef objid) {
        if (this.storage == null) {
            this.initialize();
        }
        return (ArrayDBIDs)this.storage.get(objid);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "SNN id index";
    }

    @Override
    public String getShortName() {
        return "SNN-index";
    }

    @Override
    public void logStatistics() {
    }

    @Override
    public int getNumberOfNeighbors() {
        return this.numberOfNeighbors;
    }

    public static class Factory<O>
    implements SharedNearestNeighborIndex.Factory<O> {
        public static final OptionID NUMBER_OF_NEIGHBORS_ID = new OptionID("sharedNearestNeighbors", "number of nearest neighbors to consider (at least 1)");
        public static final OptionID DISTANCE_FUNCTION_ID = new OptionID("SNNDistanceFunction", "the distance function to asses the nearest neighbors");
        protected int numberOfNeighbors;
        protected DistanceFunction<O> distanceFunction;

        public Factory(int numberOfNeighbors, DistanceFunction<O> distanceFunction) {
            this.numberOfNeighbors = numberOfNeighbors;
            this.distanceFunction = distanceFunction;
        }

        @Override
        public SharedNearestNeighborPreprocessor<O> instantiate(Relation<O> relation) {
            return new SharedNearestNeighborPreprocessor<O>(relation, this.numberOfNeighbors, this.distanceFunction);
        }

        @Override
        public int getNumberOfNeighbors() {
            return this.numberOfNeighbors;
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.distanceFunction.getInputTypeRestriction();
        }

        public static class Parameterizer<O>
        extends AbstractParameterizer {
            protected int numberOfNeighbors;
            protected DistanceFunction<O> distanceFunction;

            @Override
            protected void makeOptions(Parameterization config) {
                ObjectParameter distanceFunctionP;
                super.makeOptions(config);
                IntParameter numberOfNeighborsP = (IntParameter)new IntParameter(NUMBER_OF_NEIGHBORS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (config.grab(numberOfNeighborsP)) {
                    this.numberOfNeighbors = (Integer)numberOfNeighborsP.getValue();
                }
                if (config.grab(distanceFunctionP = new ObjectParameter(DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class))) {
                    this.distanceFunction = (DistanceFunction)distanceFunctionP.instantiateClass(config);
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.numberOfNeighbors, this.distanceFunction);
            }
        }
    }
}

