/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.projected;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.LngLatToECEFProjection;
import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.ProjectedView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.geo.LngLatDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.projected.ProjectedIndex;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class LngLatAsECEFIndex<O extends NumberVector>
extends ProjectedIndex<O, O> {
    public LngLatAsECEFIndex(Relation<? extends O> relation, Projection<O, O> proj, Relation<O> view, Index inner, boolean norefine) {
        super(relation, proj, view, inner, norefine, 1.0);
    }

    @Override
    public String getLongName() {
        return "projected " + this.inner.getLongName();
    }

    @Override
    public String getShortName() {
        return "proj-" + this.inner.getShortName();
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (!(this.inner instanceof KNNIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!LngLatDistanceFunction.class.isInstance(distanceQuery.getDistanceFunction())) {
            return null;
        }
        for (Object o : hints) {
            if (o != "exact") continue;
            return null;
        }
        DistanceQuery innerQuery = EuclideanDistanceFunction.STATIC.instantiate(this.view);
        KNNQuery innerq = ((KNNIndex)this.inner).getKNNQuery(innerQuery, hints);
        if (innerq == null) {
            return null;
        }
        return new ProjectedIndex.ProjectedKNNQuery(this, distanceQuery, innerq);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (!(this.inner instanceof RangeIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!LngLatDistanceFunction.class.isInstance(distanceQuery.getDistanceFunction())) {
            return null;
        }
        for (Object o : hints) {
            if (o != "exact") continue;
            return null;
        }
        DistanceQuery innerQuery = EuclideanDistanceFunction.STATIC.instantiate(this.view);
        RangeQuery innerq = ((RangeIndex)this.inner).getRangeQuery(innerQuery, hints);
        if (innerq == null) {
            return null;
        }
        return new ProjectedIndex.ProjectedRangeQuery(this, distanceQuery, innerq);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (!(this.inner instanceof RKNNIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!LngLatDistanceFunction.class.isInstance(distanceQuery.getDistanceFunction())) {
            return null;
        }
        for (Object o : hints) {
            if (o != "exact") continue;
            return null;
        }
        DistanceQuery innerQuery = EuclideanDistanceFunction.STATIC.instantiate(this.view);
        RKNNQuery innerq = ((RKNNIndex)this.inner).getRKNNQuery(innerQuery, hints);
        if (innerq == null) {
            return null;
        }
        return new ProjectedIndex.ProjectedRKNNQuery(this, distanceQuery, innerq);
    }

    public static class Factory<O extends NumberVector>
    extends ProjectedIndex.Factory<O, O> {
        public Factory(IndexFactory<O> inner, boolean materialize, boolean norefine, EarthModel model) {
            super(new LngLatToECEFProjection(model), inner, materialize, norefine, 1.0);
        }

        @Override
        public ProjectedIndex<O, O> instantiate(Relation<O> relation) {
            AbstractRelation view;
            if (!this.proj.getInputDataTypeInformation().isAssignableFromType(relation.getDataTypeInformation())) {
                return null;
            }
            this.proj.initialize(relation.getDataTypeInformation());
            if (this.materialize) {
                DBIDs ids = relation.getDBIDs();
                WritableDataStore content = DataStoreUtil.makeStorage(ids, 30, this.proj.getOutputDataTypeInformation().getRestrictionClass());
                DBIDIter iter = ids.iter();
                while (iter.valid()) {
                    content.put(iter, this.proj.project(relation.get(iter)));
                    iter.advance();
                }
                view = new MaterializedRelation("ECEF Projection", "ecef-projection", this.proj.getOutputDataTypeInformation(), content, ids);
            } else {
                view = new ProjectedView(relation, this.proj);
            }
            Index inneri = this.inner.instantiate(view);
            if (inneri == null) {
                return null;
            }
            return new LngLatAsECEFIndex<O>(relation, this.proj, view, inneri, this.norefine);
        }

        public static class Parameterizer<O extends NumberVector>
        extends AbstractParameterizer {
            IndexFactory<O> inner;
            boolean materialize = false;
            boolean norefine = false;
            EarthModel model;

            @Override
            protected void makeOptions(Parameterization config) {
                Flag norefineF;
                Flag materializeF;
                ObjectParameter innerP;
                super.makeOptions(config);
                ObjectParameter modelP = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class);
                if (config.grab(modelP)) {
                    this.model = (EarthModel)modelP.instantiateClass(config);
                }
                if (config.grab(innerP = new ObjectParameter(ProjectedIndex.Factory.Parameterizer.INDEX_ID, IndexFactory.class))) {
                    this.inner = (IndexFactory)innerP.instantiateClass(config);
                }
                if (config.grab(materializeF = new Flag(ProjectedIndex.Factory.Parameterizer.MATERIALIZE_FLAG))) {
                    this.materialize = materializeF.isTrue();
                }
                if (config.grab(norefineF = new Flag(ProjectedIndex.Factory.Parameterizer.DISABLE_REFINE_FLAG))) {
                    this.norefine = norefineF.isTrue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.inner, this.materialize, this.norefine, this.model);
            }
        }
    }
}

