/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.projected;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.RandomProjection;
import de.lmu.ifi.dbs.elki.data.projection.random.AchlioptasRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.projected.ProjectedIndex;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

@Title(value="PINN: Projection Indexed Nearest Neighbors")
@Reference(title="Finding local anomalies in very high dimensional space", authors="T. de Vries, S. Chawla, M. E. Houle", booktitle="Proc. IEEE 10th International Conference on Data Mining (ICDM)", url="https://doi.org/10.1109/ICDM.2010.151", bibkey="DBLP:conf/icdm/VriesCH10")
public class PINN<O extends NumberVector>
extends ProjectedIndex.Factory<O, O> {
    public PINN(IndexFactory<O> inner, int t, double s, double h, RandomFactory random) {
        super(new RandomProjection(t, new AchlioptasRandomProjectionFamily(s, random)), inner, true, false, h);
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID T_ID = new OptionID("pinn.t", "Target dimensionality.");
        public static final OptionID S_ID = new OptionID("pinn.s", "Sparsity of the random projection.");
        public static final OptionID H_ID = new OptionID("pinn.hmult", "Multiplicator for neighborhood size.");
        public static final OptionID RANDOM_ID = new OptionID("pinn.seed", "Random generator seed.");
        IndexFactory<O> inner;
        int t;
        double s;
        double h;
        RandomFactory random;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter randomP;
            DoubleParameter hP;
            DoubleParameter sP;
            IntParameter tP;
            super.makeOptions(config);
            ObjectParameter innerP = new ObjectParameter(ProjectedIndex.Factory.Parameterizer.INDEX_ID, IndexFactory.class);
            if (config.grab(innerP)) {
                this.inner = (IndexFactory)innerP.instantiateClass(config);
            }
            if (config.grab(tP = (IntParameter)new IntParameter(T_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.t = tP.intValue();
            }
            if (config.grab(sP = (DoubleParameter)new DoubleParameter(S_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_DOUBLE))) {
                this.s = sP.doubleValue();
            }
            if (config.grab(hP = (DoubleParameter)new DoubleParameter(H_ID, 3.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_DOUBLE))) {
                this.h = hP.doubleValue();
            }
            if (config.grab(randomP = new RandomParameter(RANDOM_ID))) {
                this.random = (RandomFactory)randomP.getValue();
            }
        }

        @Override
        protected PINN<O> makeInstance() {
            return new PINN<O>(this.inner, this.t, this.s, this.h, this.random);
        }
    }
}

