/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.projected;

import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.ProjectedView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public class ProjectedIndex<O, I>
implements KNNIndex<O>,
RKNNIndex<O>,
RangeIndex<O> {
    private static final Logging LOG = Logging.getLogger(ProjectedIndex.class);
    Index inner;
    Projection<O, I> proj;
    Relation<? extends O> relation;
    Relation<I> view;
    boolean norefine;
    double kmulti = 1.0;
    final Counter refinements;

    public ProjectedIndex(Relation<? extends O> relation, Projection<O, I> proj, Relation<I> view, Index inner, boolean norefine, double kmulti) {
        this.relation = relation;
        this.view = view;
        this.inner = inner;
        this.proj = proj;
        this.norefine = norefine;
        this.kmulti = kmulti;
        this.refinements = LOG.isStatistics() ? LOG.newCounter(this.getClass().getName() + ".refinements") : null;
    }

    private void countRefinement() {
        if (this.refinements != null) {
            this.refinements.increment();
        }
    }

    @Override
    public void initialize() {
        this.inner.initialize();
    }

    @Override
    public String getLongName() {
        return "projected " + this.inner.getLongName();
    }

    @Override
    public String getShortName() {
        return "proj-" + this.inner.getShortName();
    }

    @Override
    public void logStatistics() {
        if (this.refinements != null) {
            LOG.statistics(this.refinements);
        }
        this.inner.logStatistics();
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (!(this.inner instanceof KNNIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        for (Object o : hints) {
            if (o != "exact") continue;
            return null;
        }
        DistanceQuery<I> innerQuery = distanceQuery.getDistanceFunction().instantiate(this.view);
        KNNQuery<I> innerq = ((KNNIndex)this.inner).getKNNQuery(innerQuery, hints);
        if (innerq == null) {
            return null;
        }
        return new ProjectedKNNQuery(distanceQuery, innerq);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (!(this.inner instanceof RangeIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        for (Object o : hints) {
            if (o != "exact") continue;
            return null;
        }
        DistanceQuery<I> innerQuery = distanceQuery.getDistanceFunction().instantiate(this.view);
        RangeQuery<I> innerq = ((RangeIndex)this.inner).getRangeQuery(innerQuery, hints);
        if (innerq == null) {
            return null;
        }
        return new ProjectedRangeQuery(distanceQuery, innerq);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (!(this.inner instanceof RKNNIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        for (Object o : hints) {
            if (o != "exact") continue;
            return null;
        }
        DistanceQuery<I> innerQuery = distanceQuery.getDistanceFunction().instantiate(this.view);
        RKNNQuery<I> innerq = ((RKNNIndex)this.inner).getRKNNQuery(innerQuery, hints);
        if (innerq == null) {
            return null;
        }
        return new ProjectedRKNNQuery(distanceQuery, innerq);
    }

    public static class Factory<O, I>
    implements IndexFactory<O> {
        Projection<O, I> proj;
        IndexFactory<I> inner;
        boolean materialize = false;
        boolean norefine = false;
        double kmulti = 1.0;

        public Factory(Projection<O, I> proj, IndexFactory<I> inner, boolean materialize, boolean norefine, double kmulti) {
            this.proj = proj;
            this.inner = inner;
            this.materialize = materialize;
            this.norefine = norefine;
            this.kmulti = kmulti;
        }

        public ProjectedIndex<O, I> instantiate(Relation<O> relation) {
            if (!this.proj.getInputDataTypeInformation().isAssignableFromType(relation.getDataTypeInformation())) {
                return null;
            }
            this.proj.initialize(relation.getDataTypeInformation());
            Index inneri = null;
            AbstractRelation view = null;
            if (this.materialize) {
                DBIDs ids = relation.getDBIDs();
                WritableDataStore<I> content = DataStoreUtil.makeStorage(ids, 30, this.proj.getOutputDataTypeInformation().getRestrictionClass());
                DBIDIter iter = ids.iter();
                while (iter.valid()) {
                    content.put(iter, this.proj.project(relation.get(iter)));
                    iter.advance();
                }
                view = new MaterializedRelation<I>("Projected Index", "projected-index", this.proj.getOutputDataTypeInformation(), content, ids);
            } else {
                view = new ProjectedView<O, I>(relation, this.proj);
            }
            inneri = this.inner.instantiate(view);
            if (inneri == null) {
                return null;
            }
            return new ProjectedIndex<O, I>(relation, this.proj, view, inneri, this.norefine, this.kmulti);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.proj.getInputDataTypeInformation();
        }

        public static class Parameterizer<O, I>
        extends AbstractParameterizer {
            public static final OptionID PROJ_ID = new OptionID("projindex.proj", "Projection to use for the projected index.");
            public static final OptionID INDEX_ID = new OptionID("projindex.inner", "Index to use on the projected data.");
            public static final OptionID MATERIALIZE_FLAG = new OptionID("projindex.materialize", "Flag to materialize the projected data.");
            public static final OptionID DISABLE_REFINE_FLAG = new OptionID("projindex.disable-refine", "Flag to disable refinement of distances.");
            public static final OptionID K_MULTIPLIER_ID = new OptionID("projindex.kmulti", "Multiplier for k.");
            Projection<O, I> proj;
            IndexFactory<I> inner;
            boolean materialize = false;
            boolean norefine = false;
            double kmulti = 1.0;

            @Override
            protected void makeOptions(Parameterization config) {
                DoubleParameter kmultP;
                Flag norefineF;
                Flag materializeF;
                ObjectParameter innerP;
                super.makeOptions(config);
                ObjectParameter projP = new ObjectParameter(PROJ_ID, Projection.class);
                if (config.grab(projP)) {
                    this.proj = (Projection)projP.instantiateClass(config);
                }
                if (config.grab(innerP = new ObjectParameter(INDEX_ID, IndexFactory.class))) {
                    this.inner = (IndexFactory)innerP.instantiateClass(config);
                }
                if (config.grab(materializeF = new Flag(MATERIALIZE_FLAG))) {
                    this.materialize = materializeF.isTrue();
                }
                if (config.grab(norefineF = new Flag(DISABLE_REFINE_FLAG))) {
                    this.norefine = norefineF.isTrue();
                }
                if (!this.norefine && config.grab(kmultP = (DoubleParameter)((DoubleParameter)new DoubleParameter(K_MULTIPLIER_ID).setDefaultValue((Object)1.0)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_DOUBLE))) {
                    this.kmulti = kmultP.doubleValue();
                }
            }

            @Override
            protected Factory<O, I> makeInstance() {
                return new Factory<O, I>(this.proj, this.inner, this.materialize, this.norefine, this.kmulti);
            }
        }
    }

    class ProjectedRKNNQuery
    implements RKNNQuery<O> {
        RKNNQuery<I> inner;
        DistanceQuery<O> distq;

        public ProjectedRKNNQuery(DistanceQuery<O> distanceQuery, RKNNQuery<I> inner) {
            this.inner = inner;
            this.distq = distanceQuery;
        }

        @Override
        public DoubleDBIDList getRKNNForDBID(DBIDRef id, int k) {
            return this.getRKNNForObject(ProjectedIndex.this.relation.get(id), k);
        }

        @Override
        public DoubleDBIDList getRKNNForObject(O obj, int k) {
            Object pobj = ProjectedIndex.this.proj.project(obj);
            if (ProjectedIndex.this.norefine) {
                return this.inner.getRKNNForObject(pobj, k);
            }
            DoubleDBIDList ilist = this.inner.getRKNNForObject(pobj, (int)Math.ceil((double)k * ProjectedIndex.this.kmulti));
            ModifiableDoubleDBIDList olist = DBIDUtil.newDistanceDBIDList(ilist.size());
            DoubleDBIDListIter iter = ilist.iter();
            while (iter.valid()) {
                double dist = this.distq.distance((DoubleDBIDListIter)obj, iter);
                ProjectedIndex.this.countRefinement();
                olist.add(dist, iter);
                iter.advance();
            }
            return olist;
        }

        @Override
        public List<? extends DoubleDBIDList> getRKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
            return this.inner.getRKNNForBulkDBIDs(ids, k);
        }
    }

    class ProjectedRangeQuery
    extends AbstractDistanceRangeQuery<O> {
        RangeQuery<I> inner;

        public ProjectedRangeQuery(DistanceQuery<O> distanceQuery, RangeQuery<I> inner) {
            super(distanceQuery);
            this.inner = inner;
        }

        @Override
        public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList result) {
            Object pobj = ProjectedIndex.this.proj.project(obj);
            if (ProjectedIndex.this.norefine) {
                this.inner.getRangeForObject(pobj, range, result);
                return;
            }
            DoubleDBIDList ilist = this.inner.getRangeForObject(pobj, range);
            DoubleDBIDListIter iter = ilist.iter();
            while (iter.valid()) {
                double dist = this.distanceQuery.distance(obj, iter);
                ProjectedIndex.this.countRefinement();
                if (range <= dist) {
                    result.add(dist, iter);
                }
                iter.advance();
            }
        }
    }

    class ProjectedKNNQuery
    implements KNNQuery<O> {
        KNNQuery<I> inner;
        DistanceQuery<O> distq;

        public ProjectedKNNQuery(DistanceQuery<O> distanceQuery, KNNQuery<I> inner) {
            this.inner = inner;
            this.distq = distanceQuery;
        }

        @Override
        public KNNList getKNNForDBID(DBIDRef id, int k) {
            return this.getKNNForObject(ProjectedIndex.this.relation.get(id), k);
        }

        @Override
        public List<? extends KNNList> getKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
            return this.inner.getKNNForBulkDBIDs(ids, k);
        }

        @Override
        public KNNList getKNNForObject(O obj, int k) {
            Object pobj = ProjectedIndex.this.proj.project(obj);
            if (ProjectedIndex.this.norefine) {
                return this.inner.getKNNForObject(pobj, k);
            }
            KNNList ilist = this.inner.getKNNForObject(pobj, (int)Math.ceil((double)k * ProjectedIndex.this.kmulti));
            KNNHeap heap = DBIDUtil.newHeap(k);
            DoubleDBIDListIter iter = ilist.iter();
            while (iter.valid()) {
                heap.insert(this.distq.distance((DoubleDBIDListIter)obj, iter), iter);
                ProjectedIndex.this.countRefinement();
                iter.advance();
            }
            return heap.toKNNList();
        }
    }
}

