/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree;

import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.Node;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractNode<E extends Entry>
extends AbstractExternalizablePage
implements Node<E> {
    protected int numEntries;
    protected Entry[] entries;
    protected boolean isLeaf;

    public AbstractNode() {
    }

    public AbstractNode(int capacity, boolean isLeaf) {
        this.numEntries = 0;
        this.entries = new Entry[capacity];
        this.isLeaf = isLeaf;
    }

    @Override
    public final Iterator<IndexTreePath<E>> children(final IndexTreePath<E> parentPath) {
        return new Iterator<IndexTreePath<E>>(){
            int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < AbstractNode.this.numEntries;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IndexTreePath<E> next() {
                AbstractNode abstractNode = AbstractNode.this;
                synchronized (abstractNode) {
                    if (this.count < AbstractNode.this.numEntries) {
                        return new IndexTreePath(parentPath, AbstractNode.this.getEntry(this.count), this.count++);
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public final int getNumEntries() {
        return this.numEntries;
    }

    @Override
    public final boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public final E getEntry(int index) {
        return (E)this.entries[index];
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.isLeaf);
        out.writeInt(this.numEntries);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.isLeaf = in.readBoolean();
        this.numEntries = in.readInt();
    }

    @Override
    public String toString() {
        return (this.isLeaf ? "LeafNode " : "DirNode ") + this.getPageID();
    }

    @Override
    public final int addLeafEntry(E entry) {
        if (!(entry instanceof LeafEntry)) {
            throw new UnsupportedOperationException("Entry is not a leaf entry!");
        }
        if (!this.isLeaf()) {
            throw new UnsupportedOperationException("Node is not a leaf node!");
        }
        return this.addEntry(entry);
    }

    @Override
    public final int addDirectoryEntry(E entry) {
        if (entry instanceof LeafEntry) {
            throw new UnsupportedOperationException("Entry is not a directory entry!");
        }
        if (this.isLeaf()) {
            throw new UnsupportedOperationException("Node is not a directory node!");
        }
        return this.addEntry(entry);
    }

    public boolean deleteEntry(int index) {
        System.arraycopy(this.entries, index + 1, this.entries, index, this.numEntries - index - 1);
        this.entries[--this.numEntries] = null;
        return true;
    }

    public final void deleteAllEntries() {
        if (this.numEntries > 0) {
            Arrays.fill(this.entries, null);
            this.numEntries = 0;
        }
    }

    public final int getCapacity() {
        return this.entries.length;
    }

    @Deprecated
    public final List<E> getEntries() {
        ArrayList<Entry> result = new ArrayList<Entry>(this.numEntries);
        for (Entry entry : this.entries) {
            if (entry == null) continue;
            result.add(entry);
        }
        return result;
    }

    private int addEntry(E entry) {
        this.entries[this.numEntries++] = entry;
        return this.numEntries - 1;
    }

    public void removeMask(long[] mask) {
        int src;
        int dest = BitsUtil.nextSetBit(mask, 0);
        if (dest < 0) {
            return;
        }
        for (src = BitsUtil.nextSetBit(mask, dest); src < this.numEntries; ++src) {
            if (BitsUtil.get(mask, src)) continue;
            this.entries[dest] = this.entries[src];
            ++dest;
        }
        int rm = src - dest;
        while (dest < this.numEntries) {
            this.entries[dest] = null;
            ++dest;
        }
        this.numEntries -= rm;
    }

    public final void splitTo(AbstractNode<E> newNode, List<E> sorting, int splitPoint) {
        int i;
        assert (this.isLeaf() == newNode.isLeaf());
        this.deleteAllEntries();
        StringBuilder msg = LoggingConfiguration.DEBUG ? new StringBuilder(1000) : null;
        for (i = 0; i < splitPoint; ++i) {
            this.addEntry((Entry)sorting.get(i));
            if (msg == null) continue;
            msg.append("n_").append(this.getPageID()).append(' ').append(sorting.get(i)).append('\n');
        }
        for (i = splitPoint; i < sorting.size(); ++i) {
            super.addEntry((Entry)sorting.get(i));
            if (msg == null) continue;
            msg.append("n_").append(newNode.getPageID()).append(' ').append(sorting.get(i)).append('\n');
        }
        if (msg != null) {
            Logging.getLogger(this.getClass().getName()).fine(msg.toString());
        }
    }

    public final void splitTo(AbstractNode<E> newNode, List<E> assignmentsToFirst, List<E> assignmentsToSecond) {
        assert (this.isLeaf() == newNode.isLeaf());
        this.deleteAllEntries();
        StringBuilder msg = LoggingConfiguration.DEBUG ? new StringBuilder(1000) : null;
        for (Entry entry : assignmentsToFirst) {
            if (msg != null) {
                msg.append("n_").append(this.getPageID()).append(' ').append(entry).append('\n');
            }
            this.addEntry(entry);
        }
        for (Entry entry : assignmentsToSecond) {
            if (msg != null) {
                msg.append("n_").append(newNode.getPageID()).append(' ').append(entry).append('\n');
            }
            super.addEntry(entry);
        }
        if (msg != null) {
            Logging.getLogger(this.getClass()).fine(msg.toString());
        }
    }

    public final void splitByMask(AbstractNode<E> newNode, long[] assignment) {
        assert (this.isLeaf() == newNode.isLeaf());
        int dest = BitsUtil.nextSetBit(assignment, 0);
        if (dest < 0) {
            throw new AbortException("No bits set in splitting mask.");
        }
        for (int pos = dest; pos < this.numEntries; ++pos) {
            if (BitsUtil.get(assignment, pos)) {
                super.addEntry(this.getEntry(pos));
                continue;
            }
            this.entries[dest] = this.entries[pos];
            ++dest;
        }
        int rm = this.numEntries - dest;
        while (dest < this.numEntries) {
            this.entries[dest] = null;
            ++dest;
        }
        this.numEntries -= rm;
    }
}

