/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree;

import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.tree.DirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.Node;
import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public abstract class IndexTree<N extends Node<E>, E extends Entry>
implements Index {
    private final PageFile<N> file;
    protected boolean initialized = false;
    protected int dirCapacity;
    protected int leafCapacity;
    protected int dirMinimum;
    protected int leafMinimum;
    private E rootEntry;

    public IndexTree(PageFile<N> pagefile) {
        this.file = pagefile;
    }

    @Override
    public void initialize() {
        TreeIndexHeader header = this.createHeader();
        if (this.file.initialize(header)) {
            this.initializeFromFile(header, this.file);
        }
        this.rootEntry = this.createRootEntry();
    }

    protected abstract Logging getLogger();

    public final E getRootEntry() {
        return this.rootEntry;
    }

    public final int getRootID() {
        return this.getPageID((Entry)this.rootEntry);
    }

    public N getRoot() {
        return (N)((Node)this.file.readPage(this.getPageID((Entry)this.rootEntry)));
    }

    protected boolean isRoot(N page) {
        return this.getRootID() == page.getPageID();
    }

    protected int getPageID(Entry entry) {
        if (entry instanceof LeafEntry) {
            throw new AbortException("Leafs do not have page ids!");
        }
        return ((DirectoryEntry)entry).getPageID();
    }

    public N getNode(int nodeID) {
        if (nodeID == this.getPageID((Entry)this.rootEntry)) {
            return this.getRoot();
        }
        return (N)((Node)this.file.readPage(nodeID));
    }

    public final N getNode(E entry) {
        return this.getNode((E)this.getPageID((Entry)entry));
    }

    protected void writeNode(N node) {
        this.file.writePage(node);
    }

    protected void deleteNode(N node) {
        this.file.deletePage(node.getPageID());
    }

    protected TreeIndexHeader createHeader() {
        return new TreeIndexHeader(this.file.getPageSize(), this.dirCapacity, this.leafCapacity, this.dirMinimum, this.leafMinimum);
    }

    public void initializeFromFile(TreeIndexHeader header, PageFile<N> file) {
        this.dirCapacity = header.getDirCapacity();
        this.leafCapacity = header.getLeafCapacity();
        this.dirMinimum = header.getDirMinimum();
        this.leafMinimum = header.getLeafMinimum();
        if (this.getLogger().isDebugging()) {
            StringBuilder msg = new StringBuilder();
            msg.append(this.getClass());
            msg.append("\n file = ").append(file.getClass());
            this.getLogger().debugFine(msg.toString());
        }
        this.initialized = true;
    }

    protected final void initialize(E exampleLeaf) {
        this.initializeCapacities(exampleLeaf);
        this.createEmptyRoot(exampleLeaf);
        Logging log = this.getLogger();
        if (log.isStatistics()) {
            String cls = this.getClass().getName();
            log.statistics(new LongStatistic(cls + ".directory.capacity", this.dirCapacity));
            log.statistics(new LongStatistic(cls + ".directory.minfill", this.dirMinimum));
            log.statistics(new LongStatistic(cls + ".leaf.capacity", this.leafCapacity));
            log.statistics(new LongStatistic(cls + ".leaf.minfill", this.leafMinimum));
        }
        this.initialized = true;
    }

    public final IndexTreePath<E> getRootPath() {
        return new IndexTreePath<E>(null, this.rootEntry, -1);
    }

    protected abstract void initializeCapacities(E var1);

    protected abstract void createEmptyRoot(E var1);

    protected abstract E createRootEntry();

    protected abstract N createNewLeafNode();

    protected abstract N createNewDirectoryNode();

    protected void preInsert(E entry) {
    }

    protected void postDelete(E entry) {
    }

    @Override
    public void logStatistics() {
        this.file.logStatistics();
    }

    protected int getPageSize() {
        return this.file.getPageSize();
    }

    public int getDirMinimum() {
        return this.dirMinimum;
    }

    public int getLeafMinimum() {
        return this.leafMinimum;
    }

    @Deprecated
    protected PageFile<N> getFile() {
        return this.file;
    }
}

