/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree;

import de.lmu.ifi.dbs.elki.index.tree.Entry;
import java.util.ArrayList;

public class IndexTreePath<E extends Entry> {
    private IndexTreePath<E> parentPath;
    private final E entry;
    private final int index;

    public IndexTreePath(IndexTreePath<E> parent, E entry, int index) {
        if (entry == null) {
            throw new IllegalArgumentException("entry in TreePath must be non null.");
        }
        this.entry = entry;
        this.index = index;
        this.parentPath = parent;
    }

    public E getEntry() {
        return this.entry;
    }

    public int getIndex() {
        return this.index;
    }

    public int getPathCount() {
        int result = 0;
        IndexTreePath<E> path = this;
        while (path != null) {
            ++result;
            path = path.parentPath;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTreePath<E> other = (IndexTreePath<E>)o;
        IndexTreePath<E> path = this;
        while (path != null) {
            if (other == null || path.index != other.index || !path.entry.equals(other.entry)) {
                return false;
            }
            other = other.parentPath;
            path = path.parentPath;
        }
        return true;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public IndexTreePath<E> getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(200).append('[');
        ArrayList<String> c = new ArrayList<String>();
        for (IndexTreePath<E> p = this; p != null; p = p.getParentPath()) {
            c.add("@" + p.index + ":" + this.entry.toString());
        }
        for (int counter = c.size() - 1; counter >= 0; --counter) {
            buffer.append((String)c.get(counter));
            if (counter <= 0) continue;
            buffer.append(", ");
        }
        return buffer.append(']').toString();
    }
}

