/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree;

import de.lmu.ifi.dbs.elki.persistent.DefaultPageHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Stack;

public class TreeIndexHeader
extends DefaultPageHeader {
    private static int SIZE = 20;
    int dirCapacity;
    int leafCapacity;
    int dirMinimum;
    int leafMinimum;
    private int emptyPagesSize = 0;
    private int largestPageID = 0;

    public TreeIndexHeader() {
    }

    public TreeIndexHeader(int pageSize, int dirCapacity, int leafCapacity, int dirMinimum, int leafMinimum) {
        super(pageSize);
        this.dirCapacity = dirCapacity;
        this.leafCapacity = leafCapacity;
        this.dirMinimum = dirMinimum;
        this.leafMinimum = leafMinimum;
    }

    @Override
    public void readHeader(RandomAccessFile file) throws IOException {
        super.readHeader(file);
        this.dirCapacity = file.readInt();
        this.leafCapacity = file.readInt();
        this.dirMinimum = file.readInt();
        this.leafMinimum = file.readInt();
        this.emptyPagesSize = file.readInt();
        this.largestPageID = file.readInt();
    }

    @Override
    public void writeHeader(RandomAccessFile file) throws IOException {
        super.writeHeader(file);
        file.writeInt(this.dirCapacity);
        file.writeInt(this.leafCapacity);
        file.writeInt(this.dirMinimum);
        file.writeInt(this.leafMinimum);
        file.writeInt(this.emptyPagesSize);
        file.writeInt(this.largestPageID);
    }

    public int getDirCapacity() {
        return this.dirCapacity;
    }

    public int getLeafCapacity() {
        return this.leafCapacity;
    }

    public int getDirMinimum() {
        return this.dirMinimum;
    }

    public int getLeafMinimum() {
        return this.leafMinimum;
    }

    public int getEmptyPagesSize() {
        return this.emptyPagesSize;
    }

    public void setEmptyPagesSize(int emptyPagesSize) {
        this.emptyPagesSize = emptyPagesSize;
    }

    public int getLargestPageID() {
        return this.largestPageID;
    }

    public void setLargestPageID(int largestPageID) {
        this.largestPageID = largestPageID;
    }

    @Override
    public int size() {
        return super.size() + SIZE;
    }

    public void writeEmptyPages(Stack<Integer> emptyPages, RandomAccessFile file) throws IOException {
        if (emptyPages.isEmpty()) {
            this.emptyPagesSize = 0;
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(emptyPages);
        oos.flush();
        byte[] bytes = baos.toByteArray();
        this.emptyPagesSize = bytes.length;
        oos.close();
        baos.close();
        if (this.emptyPagesSize > 0) {
            file.seek(file.length());
            file.write(bytes);
        }
    }

    public Stack<Integer> readEmptyPages(RandomAccessFile file) throws IOException, ClassNotFoundException {
        if (this.emptyPagesSize == 0) {
            return new Stack<Integer>();
        }
        byte[] bytes = new byte[this.emptyPagesSize];
        file.seek(file.length() - (long)this.emptyPagesSize);
        file.read(bytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Stack emptyPages = (Stack)ois.readObject();
        ois.close();
        bais.close();
        return emptyPages;
    }
}

