/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.BreadthFirstEnumeration;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.MetricalIndexTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistanceEntry;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractMTree<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry, S extends MTreeSettings<O, N, E>>
extends MetricalIndexTree<O, N, E> {
    protected static final boolean EXTRA_INTEGRITY_CHECKS = false;
    protected S settings;
    public Statistics statistics = new Statistics();

    public AbstractMTree(PageFile<N> pagefile, S settings) {
        super(pagefile);
        this.settings = settings;
    }

    @Override
    public final DistanceFunction<? super O> getDistanceFunction() {
        return ((MTreeSettings)this.settings).distanceFunction;
    }

    public String toString() {
        int dirNodes = 0;
        int leafNodes = 0;
        int objects = 0;
        int levels = 0;
        AbstractMTreeNode node = (AbstractMTreeNode)this.getRoot();
        while (!node.isLeaf()) {
            if (node.getNumEntries() <= 0) continue;
            MTreeEntry entry = (MTreeEntry)node.getEntry(0);
            node = (AbstractMTreeNode)this.getNode(entry);
            ++levels;
        }
        StringBuilder result = new StringBuilder(1000);
        BreadthFirstEnumeration enumeration = new BreadthFirstEnumeration(this, this.getRootPath());
        while (enumeration.hasNext()) {
            Object path = enumeration.next();
            MTreeEntry entry = (MTreeEntry)((IndexTreePath)path).getEntry();
            if (entry instanceof LeafEntry) {
                ++objects;
                result.append("\n    ").append(entry.toString());
                continue;
            }
            node = (AbstractMTreeNode)this.getNode(entry);
            result.append("\n\n").append(node).append(", numEntries = ").append(node.getNumEntries()).append('\n').append(entry.toString());
            if (node.isLeaf()) {
                ++leafNodes;
                continue;
            }
            ++dirNodes;
        }
        result.append(this.getClass().getName()).append(" hat ").append(levels + 1).append(" Ebenen \n").append("DirCapacity = ").append(this.dirCapacity).append('\n').append("LeafCapacity = ").append(this.leafCapacity).append('\n').append(dirNodes).append(" Directory Nodes \n").append(leafNodes).append(" Leaf Nodes \n").append(objects).append(" Objects \n");
        return result.toString();
    }

    public void insert(E entry, boolean withPreInsert) {
        Logging log = this.getLogger();
        if (log.isDebugging()) {
            log.debugFine("insert " + entry.getRoutingObjectID());
        }
        if (!this.initialized) {
            this.initialize(entry);
        }
        IndexTreePath subtree = ((MTreeSettings)this.settings).insertStrategy.choosePath(this, entry);
        if (log.isDebugging()) {
            log.debugFine("insertion-subtree " + subtree);
        }
        MTreeEntry parentEntry = (MTreeEntry)subtree.getEntry();
        entry.setParentDistance(this.distance(parentEntry.getRoutingObjectID(), entry.getRoutingObjectID()));
        if (withPreInsert) {
            this.preInsert(entry);
        }
        AbstractMTreeNode parent = (AbstractMTreeNode)this.getNode(parentEntry);
        parent.addLeafEntry(entry);
        this.writeNode(parent);
        this.adjustTree(subtree);
    }

    public void insertAll(List<E> entries) {
        if (!this.initialized && !entries.isEmpty()) {
            this.initialize((Entry)entries.get(0));
        }
        for (MTreeEntry entry : entries) {
            this.insert(entry, false);
        }
    }

    @Override
    protected final void createEmptyRoot(E exampleLeaf) {
        this.writeNode(this.createNewLeafNode());
    }

    protected final List<DoubleIntPair> getSortedEntries(N node, DBID q) {
        ArrayList<DoubleIntPair> result = new ArrayList<DoubleIntPair>();
        for (int i = 0; i < ((AbstractNode)node).getNumEntries(); ++i) {
            MTreeEntry entry = (MTreeEntry)((AbstractNode)node).getEntry(i);
            double distance = this.distance(entry.getRoutingObjectID(), q);
            double radius = entry.getCoveringRadius();
            double minDist = radius > distance ? 0.0 : distance - radius;
            result.add(new DoubleIntPair(minDist, i));
        }
        Collections.sort(result);
        return result;
    }

    public abstract double distance(DBIDRef var1, DBIDRef var2);

    public final double distance(E e1, E e2) {
        return this.distance(e1.getRoutingObjectID(), e2.getRoutingObjectID());
    }

    protected abstract E createNewDirectoryEntry(N var1, DBID var2, double var3);

    private void adjustTree(IndexTreePath<E> subtree) {
        Logging log = this.getLogger();
        if (log.isDebugging()) {
            log.debugFine("Adjust tree " + subtree + "\n");
        }
        int nodeIndex = subtree.getIndex();
        AbstractMTreeNode node = (AbstractMTreeNode)this.getNode(subtree.getEntry());
        if (this.hasOverflow(node)) {
            MTreeEntry e;
            Assignments assignments = ((MTreeSettings)this.settings).splitStrategy.split(this, node);
            AbstractMTreeNode newNode = node.isLeaf() ? (AbstractMTreeNode)this.createNewLeafNode() : (AbstractMTreeNode)this.createNewDirectoryNode();
            ArrayList<MTreeEntry> entries1 = new ArrayList<MTreeEntry>(assignments.getFirstAssignments().size());
            ArrayList<MTreeEntry> entries2 = new ArrayList<MTreeEntry>(assignments.getSecondAssignments().size());
            for (DistanceEntry ent : assignments.getFirstAssignments()) {
                e = (MTreeEntry)ent.getEntry();
                e.setParentDistance(ent.getDistance());
                entries1.add(e);
            }
            for (DistanceEntry ent : assignments.getSecondAssignments()) {
                e = (MTreeEntry)ent.getEntry();
                e.setParentDistance(ent.getDistance());
                entries2.add(e);
            }
            node.splitTo(newNode, entries1, entries2);
            this.writeNode(node);
            this.writeNode(newNode);
            if (log.isDebuggingFine()) {
                log.debugFine(new StringBuilder(1000).append("Split Node ").append(node.getPageID()).append(" (").append(this.getClass()).append(')').append(FormatUtil.NEWLINE).append("      newNode ").append(newNode.getPageID()).append(FormatUtil.NEWLINE).append("      firstPromoted ").append(assignments.getFirstRoutingObject()).append(FormatUtil.NEWLINE).append("      firstAssignments(").append(node.getPageID()).append(") ").append(assignments.getFirstAssignments()).append(FormatUtil.NEWLINE).append("      firstCR ").append(assignments.computeFirstCover(node.isLeaf())).append(FormatUtil.NEWLINE).append("      secondPromoted ").append(assignments.getSecondRoutingObject()).append(FormatUtil.NEWLINE).append("      secondAssignments(").append(newNode.getPageID()).append(") ").append(assignments.getSecondAssignments()).append(FormatUtil.NEWLINE).append("      secondCR ").append(assignments.computeSecondCover(node.isLeaf())).append(FormatUtil.NEWLINE));
            }
            if (this.isRoot(node)) {
                IndexTreePath<E> newRootPath = this.createNewRoot(node, newNode, assignments.getFirstRoutingObject(), assignments.getSecondRoutingObject());
                this.adjustTree(newRootPath);
            } else {
                MTreeEntry parentEntry = (MTreeEntry)subtree.getParentPath().getEntry();
                AbstractMTreeNode parent = (AbstractMTreeNode)this.getNode(parentEntry);
                if (log.isDebugging()) {
                    log.debugFine("parent " + parent);
                }
                double parentDistance2 = this.distance(parentEntry.getRoutingObjectID(), assignments.getSecondRoutingObject());
                parent.addDirectoryEntry(this.createNewDirectoryEntry(newNode, assignments.getSecondRoutingObject(), parentDistance2));
                double parentDistance1 = this.distance(parentEntry.getRoutingObjectID(), assignments.getFirstRoutingObject());
                node.adjustEntry((MTreeEntry)parent.getEntry(nodeIndex), assignments.getFirstRoutingObject(), parentDistance1, this);
                this.writeNode(parent);
                this.adjustTree(subtree.getParentPath());
            }
        } else if (!this.isRoot(node)) {
            MTreeEntry parentEntry = (MTreeEntry)subtree.getParentPath().getEntry();
            AbstractMTreeNode parent = (AbstractMTreeNode)this.getNode(parentEntry);
            MTreeEntry entry = (MTreeEntry)parent.getEntry(subtree.getIndex());
            boolean changed = node.adjustEntry(entry, entry.getRoutingObjectID(), entry.getParentDistance(), this);
            if (changed) {
                this.writeNode(parent);
                this.adjustTree(subtree.getParentPath());
            }
        } else {
            MTreeEntry rootEntry = (MTreeEntry)this.getRootEntry();
            node.adjustEntry(rootEntry, rootEntry.getRoutingObjectID(), rootEntry.getParentDistance(), this);
        }
    }

    private boolean hasOverflow(N node) {
        return ((AbstractNode)node).getNumEntries() == (((AbstractNode)node).isLeaf() ? this.leafCapacity : this.dirCapacity);
    }

    private IndexTreePath<E> createNewRoot(N oldRoot, N newNode, DBID firstRoutingObjectID, DBID secondRoutingObjectID) {
        AbstractMTreeNode root = (AbstractMTreeNode)this.createNewDirectoryNode();
        this.writeNode(root);
        ((AbstractExternalizablePage)oldRoot).setPageID(root.getPageID());
        if (!((AbstractNode)oldRoot).isLeaf()) {
            for (int i = 0; i < ((AbstractNode)oldRoot).getNumEntries(); ++i) {
                this.writeNode(this.getNode(((AbstractNode)oldRoot).getEntry(i)));
            }
        }
        root.setPageID(this.getRootID());
        E oldRootEntry = this.createNewDirectoryEntry(oldRoot, firstRoutingObjectID, 0.0);
        E newRootEntry = this.createNewDirectoryEntry(newNode, secondRoutingObjectID, 0.0);
        root.addDirectoryEntry(oldRootEntry);
        root.addDirectoryEntry(newRootEntry);
        this.writeNode(root);
        this.writeNode(oldRoot);
        this.writeNode(newNode);
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("Create new Root: ID=" + root.getPageID() + "\nchild1 " + oldRoot + "\nchild2 " + newNode);
        }
        return new IndexTreePath(null, this.getRootEntry(), -1);
    }

    @Override
    public List<E> getLeaves() {
        ArrayList<MTreeEntry> result = new ArrayList<MTreeEntry>();
        BreadthFirstEnumeration enumeration = new BreadthFirstEnumeration(this, this.getRootPath());
        while (enumeration.hasNext()) {
            Object path = enumeration.next();
            MTreeEntry entry = (MTreeEntry)((IndexTreePath)path).getEntry();
            if (entry instanceof LeafEntry || !((AbstractMTreeNode)this.getNode(entry)).isLeaf()) continue;
            result.add(entry);
        }
        return result;
    }

    public int getHeight() {
        int levels = 0;
        AbstractMTreeNode node = (AbstractMTreeNode)this.getRoot();
        while (!node.isLeaf()) {
            if (node.getNumEntries() <= 0) continue;
            node = (AbstractMTreeNode)this.getNode(node.getEntry(0));
            ++levels;
        }
        return levels;
    }

    @Override
    public void logStatistics() {
        super.logStatistics();
        Logging log = this.getLogger();
        if (log.isStatistics()) {
            log.statistics(new LongStatistic(this.getClass().getName() + ".height", this.getHeight()));
            this.statistics.logStatistics();
        }
    }

    public class Statistics {
        protected final Counter distanceCalcs;
        protected final Counter knnQueries;
        protected final Counter rangeQueries;

        public Statistics() {
            Logging log = AbstractMTree.this.getLogger();
            this.distanceCalcs = log.isStatistics() ? log.newCounter(this.getClass().getName() + ".distancecalcs") : null;
            this.knnQueries = log.isStatistics() ? log.newCounter(this.getClass().getName() + ".knnqueries") : null;
            this.rangeQueries = log.isStatistics() ? log.newCounter(this.getClass().getName() + ".rangequeries") : null;
        }

        public void countDistanceCalculation() {
            if (this.distanceCalcs != null) {
                this.distanceCalcs.increment();
            }
        }

        public void countKNNQuery() {
            if (this.knnQueries != null) {
                this.knnQueries.increment();
            }
        }

        public void countRangeQuery() {
            if (this.rangeQueries != null) {
                this.rangeQueries.increment();
            }
        }

        public void logStatistics() {
            Logging log = AbstractMTree.this.getLogger();
            if (AbstractMTree.this.statistics.distanceCalcs != null) {
                log.statistics(AbstractMTree.this.statistics.distanceCalcs);
            }
            if (AbstractMTree.this.statistics.knnQueries != null) {
                log.statistics(AbstractMTree.this.statistics.knnQueries);
            }
            if (AbstractMTree.this.statistics.rangeQueries != null) {
                log.statistics(AbstractMTree.this.statistics.rangeQueries);
            }
        }
    }
}

