/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import de.lmu.ifi.dbs.elki.utilities.exceptions.InconsistentDataException;
import java.util.logging.Logger;

public abstract class AbstractMTreeNode<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry>
extends AbstractNode<E> {
    public AbstractMTreeNode() {
    }

    public AbstractMTreeNode(int capacity, boolean isLeaf) {
        super(capacity, isLeaf);
    }

    public boolean adjustEntry(E entry, DBID routingObjectID, double parentDistance, AbstractMTree<O, N, E, ?> mTree) {
        boolean changed = entry.setRoutingObjectID(routingObjectID);
        changed |= entry.setParentDistance(parentDistance);
        return changed |= entry.setCoveringRadius(this.coveringRadiusFromEntries(routingObjectID, mTree));
    }

    public double coveringRadiusFromEntries(DBID routingObjectID, AbstractMTree<O, N, E, ?> mTree) {
        double coveringRadius = 0.0;
        for (int i = 0; i < this.getNumEntries(); ++i) {
            MTreeEntry entry = (MTreeEntry)this.getEntry(i);
            double cover = entry.getParentDistance() + entry.getCoveringRadius();
            coveringRadius = coveringRadius < cover ? cover : coveringRadius;
        }
        return coveringRadius;
    }

    public final void integrityCheck(AbstractMTree<O, N, E, ?> mTree, E entry) {
        if (this.isLeaf()) {
            for (int i = 0; i < this.getCapacity(); ++i) {
                MTreeEntry e = (MTreeEntry)this.getEntry(i);
                if (i < this.getNumEntries() && e == null) {
                    throw new InconsistentDataException("i < numEntries && entry == null");
                }
                if (i < this.getNumEntries() || e == null) continue;
                throw new InconsistentDataException("i >= numEntries && entry != null");
            }
        } else {
            AbstractMTreeNode tmp = (AbstractMTreeNode)mTree.getNode((MTreeEntry)this.getEntry(0));
            boolean childIsLeaf = tmp.isLeaf();
            for (int i = 0; i < this.getCapacity(); ++i) {
                MTreeEntry e = (MTreeEntry)this.getEntry(i);
                if (i < this.getNumEntries() && e == null) {
                    throw new InconsistentDataException("i < numEntries && entry == null");
                }
                if (i >= this.getNumEntries() && e != null) {
                    throw new InconsistentDataException("i >= numEntries && entry != null");
                }
                if (e == null) continue;
                AbstractMTreeNode node = (AbstractMTreeNode)mTree.getNode(e);
                if (childIsLeaf && !node.isLeaf()) {
                    for (int k = 0; k < this.getNumEntries(); ++k) {
                        mTree.getNode((MTreeEntry)this.getEntry(k));
                    }
                    throw new InconsistentDataException("Wrong Child in " + this + " at " + i);
                }
                if (!childIsLeaf && node.isLeaf()) {
                    throw new InconsistentDataException("Wrong Child: child id no leaf, but node is leaf!");
                }
                node.integrityCheckParameters(entry, this, i, mTree);
                node.integrityCheck(mTree, e);
            }
            if (LoggingConfiguration.DEBUG) {
                Logger.getLogger(this.getClass().getName()).fine("DirNode " + this.getPageID() + " ok!");
            }
        }
    }

    protected void integrityCheckParameters(E parentEntry, N parent, int index, AbstractMTree<O, N, E, ?> mTree) {
        MTreeEntry entry = (MTreeEntry)((AbstractNode)parent).getEntry(index);
        double parentDistance = mTree.distance(entry.getRoutingObjectID(), parentEntry.getRoutingObjectID());
        if (Math.abs(entry.getParentDistance() - parentDistance) > 1.0E-10) {
            throw new InconsistentDataException("Wrong parent distance in node " + ((AbstractExternalizablePage)parent).getPageID() + " at index " + index + " (child " + entry + ")\nsoll: " + parentDistance + ",\n ist: " + entry.getParentDistance());
        }
        double mincover = parentDistance + entry.getCoveringRadius();
        if (parentEntry.getCoveringRadius() < mincover && Math.abs(parentDistance - entry.getCoveringRadius()) > 1.0E-10) {
            throw new InconsistentDataException("pcr < pd + cr \n" + parentEntry.getCoveringRadius() + " < " + parentDistance + " + " + entry.getCoveringRadius() + "in node " + ((AbstractExternalizablePage)parent).getPageID() + " at index " + index + " (child " + entry + "):\ndist(" + entry.getRoutingObjectID() + " - " + parentEntry.getRoutingObjectID() + ") >  cr(" + entry + ")");
        }
    }
}

