/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeKNNQuery;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMkTree<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry, S extends MTreeSettings<O, N, E>>
extends AbstractMTree<O, N, E, S> {
    protected KNNQuery<O> knnq;
    private DistanceQuery<O> distanceQuery;

    public AbstractMkTree(Relation<O> relation, PageFile<N> pagefile, S settings) {
        super(pagefile, settings);
        this.distanceQuery = this.getDistanceFunction().instantiate(relation);
        this.knnq = new MTreeKNNQuery<O>(this, this.distanceQuery);
    }

    @Override
    public double distance(DBIDRef id1, DBIDRef id2) {
        if (id1 == null || id2 == null) {
            return Double.NaN;
        }
        if (DBIDUtil.equal(id1, id2)) {
            return 0.0;
        }
        this.statistics.countDistanceCalculation();
        return this.distanceQuery.distance(id1, id2);
    }

    public abstract DoubleDBIDList reverseKNNQuery(DBIDRef var1, int var2);

    @Deprecated
    protected final Map<DBID, KNNList> batchNN(N node, DBIDs ids, int kmax) {
        HashMap<DBID, KNNList> res = new HashMap<DBID, KNNList>(ids.size());
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref(iter);
            res.put(id, this.knnq.getKNNForDBID(id, kmax));
            iter.advance();
        }
        return res;
    }
}

