/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.AbstractMkTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeHeader;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.List;
import java.util.Map;

public abstract class AbstractMkTreeUnified<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry, S extends MkTreeSettings<O, N, E>>
extends AbstractMkTree<O, N, E, S> {
    public AbstractMkTreeUnified(Relation<O> relation, PageFile<N> pagefile, S settings) {
        super(relation, pagefile, settings);
    }

    @Override
    protected TreeIndexHeader createHeader() {
        return new MkTreeHeader(this.getPageSize(), this.dirCapacity, this.leafCapacity, ((MkTreeSettings)this.settings).kmax);
    }

    @Override
    public void insertAll(List<E> entries) {
        if (entries.isEmpty()) {
            return;
        }
        if (!this.initialized) {
            this.initialize((Entry)entries.get(0));
        }
        ArrayModifiableDBIDs ids = DBIDUtil.newArray(entries.size());
        for (MTreeEntry entry : entries) {
            ids.add(entry.getRoutingObjectID());
            super.insert(entry, false);
        }
        Map<DBID, KNNList> knnLists = this.batchNN((AbstractMTreeNode)this.getRoot(), ids, ((MkTreeSettings)this.settings).kmax);
        this.kNNdistanceAdjustment((MTreeEntry)this.getRootEntry(), knnLists);
    }

    protected abstract void kNNdistanceAdjustment(E var1, Map<DBID, KNNList> var2);

    public int getKmax() {
        return ((MkTreeSettings)this.settings).kmax;
    }
}

