/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.AbstractMkTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.PolynomialApproximation;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeSearchCandidate;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.statistics.PolynomialRegression;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.UpdatableHeap;
import java.util.List;
import java.util.Map;
import net.jafama.FastMath;

public abstract class MkAppTree<O>
extends AbstractMkTree<O, MkAppTreeNode<O>, MkAppEntry, MkAppTreeSettings<O>> {
    private static final Logging LOG = Logging.getLogger(MkAppTree.class);

    public MkAppTree(Relation<O> relation, PageFile<MkAppTreeNode<O>> pageFile, MkAppTreeSettings<O> settings) {
        super(relation, pageFile, settings);
    }

    @Override
    public void insert(MkAppEntry id, boolean withPreInsert) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    protected void preInsert(MkAppEntry entry) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    public void insertAll(List<MkAppEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("insert " + entries + "\n");
        }
        if (!this.initialized) {
            this.initialize((Entry)entries.get(0));
        }
        ArrayModifiableDBIDs ids = DBIDUtil.newArray(entries.size());
        for (MkAppEntry entry : entries) {
            ids.add(entry.getRoutingObjectID());
            super.insert(entry, false);
        }
        Map<DBID, KNNList> knnLists = this.batchNN((AbstractMTreeNode)this.getRoot(), ids, ((MkAppTreeSettings)this.settings).kmax + 1);
        this.adjustApproximatedKNNDistances((MkAppEntry)this.getRootEntry(), knnLists);
    }

    @Override
    public DoubleDBIDList reverseKNNQuery(DBIDRef id, int k) {
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        UpdatableHeap pq = new UpdatableHeap();
        ((Heap)pq).add(new MTreeSearchCandidate(0.0, this.getRootID(), null, Double.NaN));
        while (!pq.isEmpty()) {
            double distance;
            MkAppEntry entry;
            int i;
            MTreeSearchCandidate pqNode = (MTreeSearchCandidate)((Heap)pq).poll();
            MkAppTreeNode node = (MkAppTreeNode)this.getNode(pqNode.nodeID);
            if (!node.isLeaf()) {
                for (i = 0; i < node.getNumEntries(); ++i) {
                    double approxValue;
                    entry = (MkAppEntry)node.getEntry(i);
                    distance = this.distance(entry.getRoutingObjectID(), id);
                    double minDist = entry.getCoveringRadius() > distance ? 0.0 : distance - entry.getCoveringRadius();
                    double d = approxValue = ((MkAppTreeSettings)this.settings).log ? FastMath.exp(entry.approximatedValueAt(k)) : entry.approximatedValueAt(k);
                    if (approxValue < 0.0) {
                        approxValue = 0.0;
                    }
                    if (!(minDist <= approxValue)) continue;
                    ((Heap)pq).add(new MTreeSearchCandidate(minDist, this.getPageID(entry), entry.getRoutingObjectID(), Double.NaN));
                }
                continue;
            }
            for (i = 0; i < node.getNumEntries(); ++i) {
                double approxValue;
                entry = (MkAppLeafEntry)node.getEntry(i);
                distance = this.distance(((MTreeLeafEntry)((Object)entry)).getRoutingObjectID(), id);
                double d = approxValue = ((MkAppTreeSettings)this.settings).log ? FastMath.exp(((MkAppLeafEntry)entry).approximatedValueAt(k)) : ((MkAppLeafEntry)entry).approximatedValueAt(k);
                if (approxValue < 0.0) {
                    approxValue = 0.0;
                }
                if (!(distance <= approxValue)) continue;
                result.add(distance, ((MTreeLeafEntry)((Object)entry)).getRoutingObjectID());
            }
        }
        return result;
    }

    public int getK_max() {
        return ((MkAppTreeSettings)this.settings).kmax;
    }

    @Override
    protected void initializeCapacities(MkAppEntry exampleLeaf) {
        int distanceSize = 8;
        double overhead = 12.125;
        if ((double)this.getPageSize() - overhead < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)((double)this.getPageSize() - overhead) / (8 + distanceSize + distanceSize + (((MkAppTreeSettings)this.settings).p + 1) * 4 + 2) + 1;
        if (this.dirCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1));
        }
        this.leafCapacity = (int)((double)this.getPageSize() - overhead) / (4 + distanceSize + (((MkAppTreeSettings)this.settings).p + 1) * 4 + 2) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1));
        }
        this.initialized = true;
        if (LOG.isVerbose()) {
            LOG.verbose("Directory Capacity: " + (this.dirCapacity - 1) + "\nLeaf Capacity:    " + (this.leafCapacity - 1));
        }
    }

    private double[] getMeanKNNList(DBIDs ids, Map<DBID, KNNList> knnLists) {
        double[] means = new double[((MkAppTreeSettings)this.settings).kmax];
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref(iter);
            KNNList knns = knnLists.get(id);
            int k = 0;
            DoubleDBIDListIter it = knns.iter();
            while (k < ((MkAppTreeSettings)this.settings).kmax && it.valid()) {
                int n = k++;
                means[n] = means[n] + it.doubleValue();
                it.advance();
            }
            iter.advance();
        }
        int k = 0;
        while (k < ((MkAppTreeSettings)this.settings).kmax) {
            int n = k++;
            means[n] = means[n] / (double)ids.size();
        }
        return means;
    }

    private void adjustApproximatedKNNDistances(MkAppEntry entry, Map<DBID, KNNList> knnLists) {
        int i;
        MkAppTreeNode node = (MkAppTreeNode)this.getNode(entry);
        if (node.isLeaf()) {
            for (i = 0; i < node.getNumEntries(); ++i) {
                MkAppLeafEntry leafEntry = (MkAppLeafEntry)node.getEntry(i);
                PolynomialApproximation approx = this.approximateKnnDistances(this.getMeanKNNList(leafEntry.getDBID(), knnLists));
                leafEntry.setKnnDistanceApproximation(approx);
            }
        } else {
            for (i = 0; i < node.getNumEntries(); ++i) {
                MkAppEntry dirEntry = (MkAppEntry)node.getEntry(i);
                this.adjustApproximatedKNNDistances(dirEntry, knnLists);
            }
        }
        ArrayModifiableDBIDs ids = DBIDUtil.newArray();
        this.leafEntryIDs(node, ids);
        PolynomialApproximation approx = this.approximateKnnDistances(this.getMeanKNNList(ids, knnLists));
        entry.setKnnDistanceApproximation(approx);
    }

    private void leafEntryIDs(MkAppTreeNode<O> node, ModifiableDBIDs result) {
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                MkAppEntry entry = (MkAppEntry)node.getEntry(i);
                result.add(((LeafEntry)((Object)entry)).getDBID());
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                MkAppTreeNode childNode = (MkAppTreeNode)this.getNode(node.getEntry(i));
                this.leafEntryIDs(childNode, result);
            }
        }
    }

    private PolynomialApproximation approximateKnnDistances(double[] knnDistances) {
        StringBuilder msg = new StringBuilder();
        int k_0 = 0;
        if (((MkAppTreeSettings)this.settings).log) {
            double dist;
            for (int i = 0; i < ((MkAppTreeSettings)this.settings).kmax && (dist = knnDistances[i]) == 0.0; ++i) {
                ++k_0;
            }
        }
        double[] x = new double[((MkAppTreeSettings)this.settings).kmax - k_0];
        double[] y = new double[((MkAppTreeSettings)this.settings).kmax - k_0];
        for (int k = 0; k < ((MkAppTreeSettings)this.settings).kmax - k_0; ++k) {
            if (((MkAppTreeSettings)this.settings).log) {
                x[k] = FastMath.log(k + k_0);
                y[k] = FastMath.log(knnDistances[k + k_0]);
                continue;
            }
            x[k] = k + k_0;
            y[k] = knnDistances[k + k_0];
        }
        PolynomialRegression regression = new PolynomialRegression(y, x, ((MkAppTreeSettings)this.settings).p);
        PolynomialApproximation approximation = new PolynomialApproximation(regression.getEstimatedCoefficients());
        if (LOG.isDebugging()) {
            msg.append("approximation ").append(approximation);
            LOG.debugFine(msg.toString());
        }
        return approximation;
    }

    @Override
    protected MkAppTreeNode<O> createNewLeafNode() {
        return new MkAppTreeNode(this.leafCapacity, true);
    }

    @Override
    protected MkAppTreeNode<O> createNewDirectoryNode() {
        return new MkAppTreeNode(this.dirCapacity, false);
    }

    @Override
    protected MkAppEntry createNewDirectoryEntry(MkAppTreeNode<O> node, DBID routingObjectID, double parentDistance) {
        return new MkAppDirectoryEntry(routingObjectID, parentDistance, node.getPageID(), node.coveringRadiusFromEntries(routingObjectID, this), null);
    }

    @Override
    protected MkAppEntry createRootEntry() {
        return new MkAppDirectoryEntry(null, 0.0, 0, 0.0, null);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

