/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeFactory;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeSettings;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.persistent.PageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class MkAppTreeFactory<O>
extends AbstractMTreeFactory<O, MkAppTreeNode<O>, MkAppEntry, MkAppTreeSettings<O>> {
    public MkAppTreeFactory(PageFileFactory<?> pageFileFactory, MkAppTreeSettings<O> settings) {
        super(pageFileFactory, settings);
    }

    public MkAppTreeIndex<O> instantiate(Relation<O> relation) {
        PageFile<MkAppTreeNode<O>> pagefile = this.makePageFile(this.getNodeClass());
        return new MkAppTreeIndex<O>(relation, pagefile, (MkAppTreeSettings)this.settings);
    }

    protected Class<MkAppTreeNode<O>> getNodeClass() {
        return ClassGenericsUtil.uglyCastIntoSubclass(MkAppTreeNode.class);
    }

    public static class Parameterizer<O>
    extends AbstractMTreeFactory.Parameterizer<O, MkAppTreeNode<O>, MkAppEntry, MkAppTreeSettings<O>> {
        public static final OptionID NOLOG_ID = new OptionID("mkapp.nolog", "Flag to indicate that the approximation is done in the ''normal'' space instead of the log-log space (which is default).");
        public static final OptionID K_ID = new OptionID("mkapp.k", "positive integer specifying the maximum number k of reverse k nearest neighbors to be supported.");
        public static final OptionID P_ID = new OptionID("mkapp.p", "positive integer specifying the order of the polynomial approximation.");

        @Override
        protected void makeOptions(Parameterization config) {
            Flag nologF;
            IntParameter pP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                ((MkAppTreeSettings)this.settings).kmax = (Integer)kP.getValue();
            }
            if (config.grab(pP = (IntParameter)new IntParameter(P_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                ((MkAppTreeSettings)this.settings).p = (Integer)pP.getValue();
            }
            if (config.grab(nologF = new Flag(NOLOG_ID))) {
                ((MkAppTreeSettings)this.settings).log = (Boolean)nologF.getValue() == false;
            }
        }

        @Override
        protected MkAppTreeFactory<O> makeInstance() {
            return new MkAppTreeFactory(this.pageFileFactory, (MkAppTreeSettings)this.settings);
        }

        @Override
        protected MkAppTreeSettings<O> makeSettings() {
            return new MkAppTreeSettings();
        }
    }
}

