/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeKNNQuery;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeRangeQuery;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MkTreeRKNNQuery;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.ArrayList;
import java.util.List;

public class MkAppTreeIndex<O>
extends MkAppTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
RKNNIndex<O> {
    private Relation<O> relation;

    public MkAppTreeIndex(Relation<O> relation, PageFile<MkAppTreeNode<O>> pageFile, MkAppTreeSettings<O> settings) {
        super(relation, pageFile, settings);
        this.relation = relation;
    }

    protected MkAppEntry createNewLeafEntry(DBID id, O object, double parentDistance) {
        return new MkAppLeafEntry(id, parentDistance, null);
    }

    @Override
    public void initialize() {
        super.initialize();
        ArrayList<MkAppEntry> objs = new ArrayList<MkAppEntry>(this.relation.size());
        DBIDIter iter = this.relation.iterDBIDs();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref(iter);
            O object = this.relation.get(id);
            objs.add(this.createNewLeafEntry(id, object, Double.NaN));
            iter.advance();
        }
        this.insertAll((List<MkAppEntry>)objs);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MTreeKNNQuery<O>(this, distanceQuery);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MTreeRangeQuery<O>(this, distanceQuery);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MkTreeRKNNQuery<O>(this, distanceQuery);
    }

    @Override
    public String getLongName() {
        return "MkApp-Tree";
    }

    @Override
    public String getShortName() {
        return "mkapptree";
    }
}

