/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.MkAppEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp.PolynomialApproximation;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import java.util.Arrays;
import java.util.logging.Logger;

class MkAppTreeNode<O>
extends AbstractMTreeNode<O, MkAppTreeNode<O>, MkAppEntry> {
    private static final long serialVersionUID = 2L;

    public MkAppTreeNode() {
    }

    public MkAppTreeNode(int capacity, boolean isLeaf) {
        super(capacity, isLeaf);
    }

    protected PolynomialApproximation knnDistanceApproximation() {
        int p_max = 0;
        double[] b = null;
        for (int i = 0; i < this.getNumEntries(); ++i) {
            MkAppEntry entry = (MkAppEntry)this.getEntry(i);
            PolynomialApproximation approximation = entry.getKnnDistanceApproximation();
            if (b == null) {
                p_max = approximation.getPolynomialOrder();
                b = new double[p_max];
            }
            for (int p = 0; p < p_max; ++p) {
                int n = p;
                b[n] = b[n] + approximation.getB(p);
            }
        }
        int p = 0;
        while (p < p_max) {
            int n = p++;
            b[n] = b[n] / (double)p_max;
        }
        if (LoggingConfiguration.DEBUG) {
            StringBuilder msg = new StringBuilder();
            msg.append("b " + FormatUtil.format(b, FormatUtil.NF4));
            Logger.getLogger(this.getClass().getName()).fine(msg.toString());
        }
        return new PolynomialApproximation(b);
    }

    @Override
    public boolean adjustEntry(MkAppEntry entry, DBID routingObjectID, double parentDistance, AbstractMTree<O, MkAppTreeNode<O>, MkAppEntry, ?> mTree) {
        super.adjustEntry(entry, routingObjectID, parentDistance, mTree);
        return true;
    }

    @Override
    protected void integrityCheckParameters(MkAppEntry parentEntry, MkAppTreeNode<O> parent, int index, AbstractMTree<O, MkAppTreeNode<O>, MkAppEntry, ?> mTree) {
        super.integrityCheckParameters(parentEntry, parent, index, mTree);
        MkAppEntry entry = (MkAppEntry)parent.getEntry(index);
        PolynomialApproximation approximation_soll = this.knnDistanceApproximation();
        PolynomialApproximation approximation_ist = entry.getKnnDistanceApproximation();
        if (!Arrays.equals(approximation_ist.getCoefficients(), approximation_soll.getCoefficients())) {
            String soll = approximation_soll.toString();
            String ist = entry.getKnnDistanceApproximation().toString();
            throw new RuntimeException("Wrong polynomial approximation in node " + parent.getPageID() + " at index " + index + " (child " + entry + ")\nsoll: " + soll + ",\n ist: " + ist);
        }
    }
}

