/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.ApproximationLine;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class MkCoPLeafEntry
extends MTreeLeafEntry
implements MkCoPEntry {
    private static final long serialVersionUID = 2L;
    private ApproximationLine conservativeApproximation;
    private ApproximationLine progressiveApproximation;

    public MkCoPLeafEntry() {
    }

    public MkCoPLeafEntry(DBID objectID, double parentDistance, ApproximationLine conservativeApproximation, ApproximationLine progressiveApproximation) {
        super(objectID, parentDistance);
        this.conservativeApproximation = conservativeApproximation;
        this.progressiveApproximation = progressiveApproximation;
    }

    @Override
    public double approximateConservativeKnnDistance(int k) {
        return this.conservativeApproximation.getApproximatedKnnDistance(k);
    }

    public double approximateProgressiveKnnDistance(int k) {
        return this.progressiveApproximation.getApproximatedKnnDistance(k);
    }

    @Override
    public ApproximationLine getConservativeKnnDistanceApproximation() {
        return this.conservativeApproximation;
    }

    public ApproximationLine getProgressiveKnnDistanceApproximation() {
        return this.progressiveApproximation;
    }

    @Override
    public void setConservativeKnnDistanceApproximation(ApproximationLine conservativeApproximation) {
        this.conservativeApproximation = conservativeApproximation;
    }

    public void setProgressiveKnnDistanceApproximation(ApproximationLine progressiveApproximation) {
        this.progressiveApproximation = progressiveApproximation;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.conservativeApproximation);
        out.writeObject(this.progressiveApproximation);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.conservativeApproximation = (ApproximationLine)in.readObject();
        this.progressiveApproximation = (ApproximationLine)in.readObject();
    }

    public String toString() {
        return super.toString() + "\ncons " + this.conservativeApproximation + "\n";
    }
}

