/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.ApproximationLine;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPTree;
import net.jafama.FastMath;

class MkCoPTreeNode<O>
extends AbstractMTreeNode<O, MkCoPTreeNode<O>, MkCoPEntry> {
    private static final long serialVersionUID = 1L;

    public MkCoPTreeNode() {
    }

    public MkCoPTreeNode(int capacity, boolean isLeaf) {
        super(capacity, isLeaf);
    }

    protected ApproximationLine conservativeKnnDistanceApproximation(int k_max) {
        ApproximationLine approx;
        MkCoPEntry entry;
        int i;
        int k_0 = k_max;
        double y_1 = Double.NEGATIVE_INFINITY;
        double y_kmax = Double.NEGATIVE_INFINITY;
        for (i = 0; i < this.getNumEntries(); ++i) {
            entry = (MkCoPEntry)this.getEntry(i);
            approx = entry.getConservativeKnnDistanceApproximation();
            k_0 = Math.min(approx.getK_0(), k_0);
        }
        for (i = 0; i < this.getNumEntries(); ++i) {
            entry = (MkCoPEntry)this.getEntry(i);
            approx = entry.getConservativeKnnDistanceApproximation();
            double entry_y_1 = approx.getValueAt(k_0);
            double entry_y_kmax = approx.getValueAt(k_max);
            if (!Double.isInfinite(entry_y_1)) {
                y_1 = Math.max(entry_y_1, y_1);
            }
            if (Double.isInfinite(entry_y_kmax)) continue;
            y_kmax = Math.max(entry_y_kmax, y_kmax);
        }
        double m = (y_kmax - y_1) / (FastMath.log(k_max) - FastMath.log(k_0));
        double t = y_1 - m * FastMath.log(k_0);
        return new ApproximationLine(k_0, m, t);
    }

    protected ApproximationLine progressiveKnnDistanceApproximation(int k_max) {
        ApproximationLine approx;
        MkCoPLeafEntry entry;
        int i;
        if (!this.isLeaf()) {
            throw new UnsupportedOperationException("Progressive KNN-distance approximation is only vailable in leaf nodes!");
        }
        int k_0 = 0;
        double y_1 = Double.POSITIVE_INFINITY;
        double y_kmax = Double.POSITIVE_INFINITY;
        for (i = 0; i < this.getNumEntries(); ++i) {
            entry = (MkCoPLeafEntry)this.getEntry(i);
            approx = entry.getProgressiveKnnDistanceApproximation();
            k_0 = Math.max(approx.getK_0(), k_0);
        }
        for (i = 0; i < this.getNumEntries(); ++i) {
            entry = (MkCoPLeafEntry)this.getEntry(i);
            approx = entry.getProgressiveKnnDistanceApproximation();
            y_1 = Math.min(approx.getValueAt(k_0), y_1);
            y_kmax = Math.min(approx.getValueAt(k_max), y_kmax);
        }
        double m = (y_kmax - y_1) / (FastMath.log(k_max) - FastMath.log(k_0));
        double t = y_1 - m * FastMath.log(k_0);
        return new ApproximationLine(k_0, m, t);
    }

    @Override
    public boolean adjustEntry(MkCoPEntry entry, DBID routingObjectID, double parentDistance, AbstractMTree<O, MkCoPTreeNode<O>, MkCoPEntry, ?> mTree) {
        super.adjustEntry(entry, routingObjectID, parentDistance, mTree);
        return true;
    }

    @Override
    protected void integrityCheckParameters(MkCoPEntry parentEntry, MkCoPTreeNode<O> parent, int index, AbstractMTree<O, MkCoPTreeNode<O>, MkCoPEntry, ?> mTree) {
        super.integrityCheckParameters(parentEntry, parent, index, mTree);
        MkCoPEntry entry = (MkCoPEntry)parent.getEntry(index);
        int k_max = ((MkCoPTree)mTree).getKmax();
        ApproximationLine approx = this.conservativeKnnDistanceApproximation(k_max);
        if (!entry.getConservativeKnnDistanceApproximation().equals(approx)) {
            String soll = approx.toString();
            String ist = entry.getConservativeKnnDistanceApproximation().toString();
            throw new RuntimeException("Wrong conservative approximation in node " + parent.getPageID() + " at index " + index + " (child " + entry + ")\nsoll: " + soll + ",\n ist: " + ist);
        }
    }
}

