/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeKNNQuery;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeRangeQuery;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MkTreeRKNNQuery;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import java.util.ArrayList;

public class MkMaxTreeIndex<O>
extends MkMaxTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
RKNNIndex<O>,
DynamicIndex {
    private Relation<O> relation;

    public MkMaxTreeIndex(Relation<O> relation, PageFile<MkMaxTreeNode<O>> pagefile, MkTreeSettings<O, MkMaxTreeNode<O>, MkMaxEntry> settings) {
        super(relation, pagefile, settings);
        this.relation = relation;
    }

    protected MkMaxLeafEntry createNewLeafEntry(DBID id, O object, double parentDistance) {
        KNNList knns = this.knnq.getKNNForObject(object, this.getKmax() - 1);
        double knnDistance = knns.getKNNDistance();
        return new MkMaxLeafEntry(id, parentDistance, knnDistance);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public void insert(DBIDRef id) {
        this.insert(this.createNewLeafEntry(DBIDUtil.deref(id), this.relation.get(id), Double.NaN), false);
    }

    @Override
    public void insertAll(DBIDs ids) {
        ArrayList<MkMaxLeafEntry> objs = new ArrayList<MkMaxLeafEntry>(ids.size());
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref(iter);
            O object = this.relation.get(id);
            objs.add(this.createNewLeafEntry(id, object, Double.NaN));
            iter.advance();
        }
        this.insertAll(objs);
    }

    @Override
    public final boolean delete(DBIDRef id) {
        throw new NotImplementedException();
    }

    @Override
    public void deleteAll(DBIDs ids) {
        throw new NotImplementedException();
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MTreeKNNQuery<O>(this, distanceQuery);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MTreeRangeQuery<O>(this, distanceQuery);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MkTreeRKNNQuery<O>(this, distanceQuery);
    }

    @Override
    public String getLongName() {
        return "MkMax-Tree";
    }

    @Override
    public String getShortName() {
        return "mkmaxtree";
    }
}

