/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeKNNQuery;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeRangeQuery;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MkTreeRKNNQuery;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.ArrayList;

public class MkTabTreeIndex<O>
extends MkTabTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
RKNNIndex<O> {
    private Relation<O> relation;

    public MkTabTreeIndex(Relation<O> relation, PageFile<MkTabTreeNode<O>> pagefile, MkTreeSettings<O, MkTabTreeNode<O>, MkTabEntry> settings) {
        super(relation, pagefile, settings);
        this.relation = relation;
    }

    protected MkTabEntry createNewLeafEntry(DBID id, O object, double parentDistance) {
        return new MkTabLeafEntry(id, parentDistance, this.knnDistances(object));
    }

    private double[] knnDistances(O object) {
        KNNList knns = this.knnq.getKNNForObject(object, this.getKmax() - 1);
        double[] distances = new double[this.getKmax()];
        DoubleDBIDListIter iter = knns.iter();
        for (int i = 0; iter.valid() && i < this.getKmax(); ++i) {
            distances[i] = iter.doubleValue();
            iter.advance();
        }
        return distances;
    }

    @Override
    public void initialize() {
        super.initialize();
        ArrayList<MkTabEntry> objs = new ArrayList<MkTabEntry>(this.relation.size());
        DBIDIter iter = this.relation.iterDBIDs();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref(iter);
            O object = this.relation.get(id);
            objs.add(this.createNewLeafEntry(id, object, Double.NaN));
            iter.advance();
        }
        this.insertAll(objs);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MTreeKNNQuery<O>(this, distanceQuery);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MTreeRangeQuery<O>(this, distanceQuery);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MkTreeRKNNQuery<O>(this, distanceQuery);
    }

    @Override
    public String getLongName() {
        return "MkTab-Tree";
    }

    @Override
    public String getShortName() {
        return "mktabtree";
    }
}

