/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mtree;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mtree.MTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mtree.MTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeKNNQuery;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeRangeQuery;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import java.util.ArrayList;

public class MTreeIndex<O>
extends MTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
DynamicIndex {
    private Relation<O> relation;
    protected DistanceQuery<O> distanceQuery;

    public MTreeIndex(Relation<O> relation, PageFile<MTreeNode<O>> pagefile, MTreeSettings<O, MTreeNode<O>, MTreeEntry> settings) {
        super(pagefile, settings);
        this.relation = relation;
        this.distanceQuery = this.getDistanceFunction().instantiate(relation);
    }

    @Override
    public double distance(DBIDRef id1, DBIDRef id2) {
        if (id1 == null || id2 == null) {
            return Double.NaN;
        }
        if (DBIDUtil.equal(id1, id2)) {
            return 0.0;
        }
        this.statistics.countDistanceCalculation();
        return this.distanceQuery.distance(id1, id2);
    }

    @Override
    protected void initializeCapacities(MTreeEntry exampleLeaf) {
        int distanceSize = 8;
        Relation<O> vrel = this.relation;
        int dim = RelationUtil.dimensionality(vrel);
        int featuresize = 8 * dim;
        if (dim <= 0) {
            this.getLogger().warning("Relation does not have a dimensionality -- simulating M-tree as external index!");
            featuresize = 0;
        }
        double overhead = 12.125;
        if ((double)this.getPageSize() - overhead < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)((double)this.getPageSize() - overhead) / (4 + featuresize + distanceSize + distanceSize) + 1;
        if (this.dirCapacity <= 2) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            this.getLogger().warning("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1));
        }
        this.leafCapacity = (int)((double)this.getPageSize() - overhead) / (4 + featuresize + distanceSize) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            this.getLogger().warning("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1));
        }
    }

    protected MTreeEntry createNewLeafEntry(DBID id, O object, double parentDistance) {
        return new MTreeLeafEntry(id, parentDistance);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public void insert(DBIDRef id) {
        this.insert(this.createNewLeafEntry(DBIDUtil.deref(id), this.relation.get(id), Double.NaN), false);
    }

    @Override
    public void insertAll(DBIDs ids) {
        ArrayList<MTreeEntry> objs = new ArrayList<MTreeEntry>(ids.size());
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref(iter);
            O object = this.relation.get(id);
            objs.add(this.createNewLeafEntry(id, object, Double.NaN));
            iter.advance();
        }
        this.insertAll(objs);
    }

    @Override
    public final boolean delete(DBIDRef id) {
        throw new NotImplementedException();
    }

    @Override
    public void deleteAll(DBIDs ids) {
        throw new NotImplementedException();
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        DistanceQuery<O> dq = distanceFunction.instantiate(this.relation);
        return new MTreeKNNQuery<O>(this, dq);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        DistanceQuery<O> dq = distanceFunction.instantiate(this.relation);
        return new MTreeRangeQuery<O>(this, dq);
    }

    @Override
    public String getLongName() {
        return "M-Tree";
    }

    @Override
    public String getShortName() {
        return "mtree";
    }
}

