/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.index.tree.DirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeSearchCandidate;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparableMinHeap;

public class MTreeKNNQuery<O>
extends AbstractDistanceKNNQuery<O> {
    protected final AbstractMTree<O, ?, ?, ?> index;

    public MTreeKNNQuery(AbstractMTree<O, ?, ?, ?> index, DistanceQuery<O> distanceQuery) {
        super(distanceQuery);
        this.index = index;
    }

    @Override
    public KNNList getKNNForObject(O q, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("At least one object has to be requested!");
        }
        this.index.statistics.countKNNQuery();
        KNNHeap knnList = DBIDUtil.newHeap(k);
        double d_k = Double.POSITIVE_INFINITY;
        ComparableMinHeap<MTreeSearchCandidate> pq = new ComparableMinHeap<MTreeSearchCandidate>();
        pq.add(new MTreeSearchCandidate(0.0, this.index.getRootID(), null, 0.0));
        while (!pq.isEmpty()) {
            MTreeEntry entry;
            int i;
            MTreeSearchCandidate pqNode = (MTreeSearchCandidate)pq.poll();
            if (knnList.size() >= k && pqNode.mindist > d_k) break;
            AbstractMTreeNode node = (AbstractMTreeNode)this.index.getNode(pqNode.nodeID);
            DBID id_p = pqNode.routingObjectID;
            double d1 = pqNode.routingDistance;
            if (!node.isLeaf()) {
                for (i = 0; i < node.getNumEntries(); ++i) {
                    double sum;
                    entry = (MTreeEntry)node.getEntry(i);
                    DBID o_r = entry.getRoutingObjectID();
                    double r_or = entry.getCoveringRadius();
                    double d2 = id_p != null ? entry.getParentDistance() : 0.0;
                    double diff = Math.abs(d1 - d2);
                    if (!(diff <= (sum = d_k + r_or))) continue;
                    double d3 = this.distanceQuery.distance(o_r, q);
                    this.index.statistics.countDistanceCalculation();
                    double d_min = Math.max(d3 - r_or, 0.0);
                    if (!(d_min <= d_k)) continue;
                    pq.add(new MTreeSearchCandidate(d_min, ((DirectoryEntry)((Object)entry)).getPageID(), o_r, d3));
                }
                continue;
            }
            for (i = 0; i < node.getNumEntries(); ++i) {
                entry = (MTreeEntry)node.getEntry(i);
                DBID o_j = entry.getRoutingObjectID();
                double d2 = id_p != null ? entry.getParentDistance() : 0.0;
                double diff = Math.abs(d1 - d2);
                if (!(diff <= d_k)) continue;
                double d3 = this.distanceQuery.distance(o_j, q);
                this.index.statistics.countDistanceCalculation();
                if (!(d3 <= d_k)) continue;
                knnList.insert(d3, o_j);
                d_k = knnList.getKNNDistance();
            }
        }
        return knnList.toKNNList();
    }
}

