/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.index.tree.DirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;

public class MTreeRangeQuery<O>
extends AbstractDistanceRangeQuery<O> {
    protected final AbstractMTree<O, ?, ?, ?> index;

    public MTreeRangeQuery(AbstractMTree<O, ?, ?, ?> index, DistanceQuery<O> distanceQuery) {
        super(distanceQuery);
        this.index = index;
    }

    private void doRangeQuery(DBID o_p, AbstractMTreeNode<O, ?, ?> node, O q, double r_q, ModifiableDoubleDBIDList result) {
        double d1 = 0.0;
        if (o_p != null) {
            d1 = this.distanceQuery.distance(o_p, q);
            this.index.statistics.countDistanceCalculation();
        }
        if (!node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                double sum;
                MTreeEntry entry = (MTreeEntry)node.getEntry(i);
                DBID o_r = entry.getRoutingObjectID();
                double r_or = entry.getCoveringRadius();
                double d2 = o_p != null ? entry.getParentDistance() : 0.0;
                double diff = Math.abs(d1 - d2);
                if (!(diff <= (sum = r_q + r_or))) continue;
                double d3 = this.distanceQuery.distance(o_r, q);
                this.index.statistics.countDistanceCalculation();
                if (!(d3 <= sum)) continue;
                AbstractMTreeNode child = (AbstractMTreeNode)this.index.getNode(((DirectoryEntry)((Object)entry)).getPageID());
                this.doRangeQuery(o_r, child, q, r_q, result);
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                MTreeEntry entry = (MTreeEntry)node.getEntry(i);
                DBID o_j = entry.getRoutingObjectID();
                double d2 = o_p != null ? entry.getParentDistance() : 0.0;
                double diff = Math.abs(d1 - d2);
                if (!(diff <= r_q)) continue;
                double d3 = this.distanceQuery.distance(o_j, q);
                this.index.statistics.countDistanceCalculation();
                if (!(d3 <= r_q)) continue;
                result.add(d3, o_j);
            }
        }
    }

    @Override
    public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList result) {
        this.index.statistics.countRangeQuery();
        this.doRangeQuery(null, (AbstractMTreeNode)this.index.getRoot(), obj, range, result);
    }
}

