/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.insert;

import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.insert.MTreeInsert;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="Proc. Int. Conf. Very Large Data Bases (VLDB'97)", url="http://www.vldb.org/conf/1997/P426.PDF", bibkey="DBLP:conf/vldb/CiacciaPZ97")
public class MinimumEnlargementInsert<N extends AbstractMTreeNode<?, N, E>, E extends MTreeEntry>
implements MTreeInsert<E, N> {
    @Override
    public IndexTreePath<E> choosePath(AbstractMTree<?, N, E, ?> tree, E object) {
        return this.choosePath(tree, object, tree.getRootPath());
    }

    private IndexTreePath<E> choosePath(AbstractMTree<?, N, E, ?> tree, E object, IndexTreePath<E> subtree) {
        AbstractMTreeNode node = (AbstractMTreeNode)tree.getNode(subtree.getEntry());
        if (node.isLeaf()) {
            return subtree;
        }
        int bestIdx = 0;
        MTreeEntry bestEntry = (MTreeEntry)node.getEntry(0);
        double bestDistance = tree.distance(object.getRoutingObjectID(), bestEntry.getRoutingObjectID());
        for (int i = 1; i < node.getNumEntries(); ++i) {
            MTreeEntry entry = (MTreeEntry)node.getEntry(i);
            double distance = tree.distance(object.getRoutingObjectID(), entry.getRoutingObjectID());
            if (!(distance < bestDistance)) continue;
            bestIdx = i;
            bestEntry = entry;
            bestDistance = distance;
        }
        return this.choosePath(tree, object, new IndexTreePath<MTreeEntry>(subtree, bestEntry, bestIdx));
    }
}

