/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split;

import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.MTreeSplit;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.GeneralizedHyperplaneDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractMTreeSplit<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
implements MTreeSplit<E, N> {
    protected DistributionStrategy distributor;

    public AbstractMTreeSplit(DistributionStrategy distributor) {
        this.distributor = distributor;
    }

    protected static <E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>> double[][] computeDistanceMatrix(AbstractMTree<?, N, E, ?> tree, N node) {
        int n = node.getNumEntries();
        double[][] distancematrix = new double[n][n];
        for (int i = 0; i < n; ++i) {
            MTreeEntry ei = (MTreeEntry)node.getEntry(i);
            double[] row_i = distancematrix[i];
            for (int j = i + 1; j < n; ++j) {
                double d = tree.distance(ei, (MTreeEntry)node.getEntry(j));
                distancematrix[j][i] = d;
                row_i[j] = d;
            }
        }
        return distancematrix;
    }

    public static abstract class Parameterizer<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
    extends AbstractParameterizer {
        public static final OptionID DISTRIBUTOR_ID = new OptionID("mtree.split.distributor", "Distribution strategy for mtree entries during splitting.");
        protected DistributionStrategy distributor;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter distributorP = new ObjectParameter(DISTRIBUTOR_ID, (Class<?>)DistributionStrategy.class, GeneralizedHyperplaneDistribution.class);
            if (config.grab(distributorP)) {
                this.distributor = (DistributionStrategy)distributorP.instantiateClass(config);
            }
        }

        @Override
        protected abstract MTreeSplit<E, N> makeInstance();
    }
}

