/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split;

import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.AbstractMTreeSplit;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;

public class FarthestPointsSplit<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
extends AbstractMTreeSplit<E, N> {
    public FarthestPointsSplit(DistributionStrategy distributor) {
        super(distributor);
    }

    @Override
    public Assignments<E> split(AbstractMTree<?, N, E, ?> tree, N node) {
        int n = ((AbstractNode)node).getNumEntries();
        double[][] distanceMatrix = FarthestPointsSplit.computeDistanceMatrix(tree, node);
        int besti = -1;
        int bestj = -1;
        double currentMaxDist = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double[] row_i = distanceMatrix[i];
            for (int j = i + 1; j < n; ++j) {
                double distance = row_i[j];
                if (!(distance > currentMaxDist)) continue;
                besti = i;
                bestj = j;
                currentMaxDist = distance;
            }
        }
        return this.distributor.distribute(node, besti, distanceMatrix[besti], bestj, distanceMatrix[bestj]);
    }

    public static class Parameterizer<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
    extends AbstractMTreeSplit.Parameterizer<E, N> {
        @Override
        protected FarthestPointsSplit<E, N> makeInstance() {
            return new FarthestPointsSplit(this.distributor);
        }
    }
}

