/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split;

import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.AbstractMTreeSplit;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="Proc. Int. Conf. Very Large Data Bases (VLDB'97)", url="http://www.vldb.org/conf/1997/P426.PDF", bibkey="DBLP:conf/vldb/CiacciaPZ97")
public class MMRadSplit<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
extends AbstractMTreeSplit<E, N> {
    public MMRadSplit(DistributionStrategy distributor) {
        super(distributor);
    }

    @Override
    public Assignments<E> split(AbstractMTree<?, N, E, ?> tree, N node) {
        int n = ((AbstractNode)node).getNumEntries();
        double[][] distanceMatrix = MMRadSplit.computeDistanceMatrix(tree, node);
        double miSumCR = Double.POSITIVE_INFINITY;
        boolean leaf = ((AbstractNode)node).isLeaf();
        Assignments bestAssignment = null;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                Assignments currentAssignments = this.distributor.distribute(node, i, distanceMatrix[i], j, distanceMatrix[j]);
                double maxCR = Math.max(currentAssignments.computeFirstCover(leaf), currentAssignments.computeSecondCover(leaf));
                if (!(maxCR < miSumCR)) continue;
                miSumCR = maxCR;
                bestAssignment = currentAssignments;
            }
        }
        return bestAssignment;
    }

    public static class Parameterizer<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
    extends AbstractMTreeSplit.Parameterizer<E, N> {
        @Override
        protected MMRadSplit<E, N> makeInstance() {
            return new MMRadSplit(this.distributor);
        }
    }
}

