/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split;

import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.AbstractMTreeSplit;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="Proc. Int. Conf. Very Large Data Bases (VLDB'97)", url="http://www.vldb.org/conf/1997/P426.PDF", bibkey="DBLP:conf/vldb/CiacciaPZ97")
public class RandomSplit<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
extends AbstractMTreeSplit<E, N> {
    private Random random;

    public RandomSplit(DistributionStrategy distributor, RandomFactory rnd) {
        super(distributor);
        this.random = rnd.getSingleThreadedRandom();
    }

    @Override
    public Assignments<E> split(AbstractMTree<?, N, E, ?> tree, N node) {
        int n = ((AbstractNode)node).getNumEntries();
        int pos1 = this.random.nextInt(n);
        int pos2 = this.random.nextInt(n - 1);
        pos2 = pos2 >= pos1 ? pos2 + 1 : pos2;
        double[] dis1 = new double[n];
        double[] dis2 = new double[n];
        MTreeEntry e1 = (MTreeEntry)((AbstractNode)node).getEntry(pos1);
        MTreeEntry e2 = (MTreeEntry)((AbstractNode)node).getEntry(pos2);
        for (int i = 0; i < n; ++i) {
            if (i == pos1 || i == pos2) continue;
            MTreeEntry ej = (MTreeEntry)((AbstractNode)node).getEntry(i);
            dis1[i] = tree.distance(e1, ej);
            dis2[i] = tree.distance(e2, ej);
        }
        return this.distributor.distribute(node, pos1, dis1, pos2, dis2);
    }

    public static class Parameterizer<E extends MTreeEntry, N extends AbstractMTreeNode<?, N, E>>
    extends AbstractMTreeSplit.Parameterizer<E, N> {
        public static final OptionID RANDOM_ID = new OptionID("mtree.randomsplit.random", "Random generator / seed for the randomized split.");
        RandomFactory rnd = RandomFactory.DEFAULT;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            RandomParameter rndP = new RandomParameter(RANDOM_ID);
            if (config.grab(rndP)) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected RandomSplit<E, N> makeInstance() {
            return new RandomSplit(this.distributor, this.rnd);
        }
    }
}

