/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution;

import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="Proc. Int. Conf. Very Large Data Bases (VLDB'97)", url="http://www.vldb.org/conf/1997/P426.PDF", bibkey="DBLP:conf/vldb/CiacciaPZ97")
public class BalancedDistribution
implements DistributionStrategy {
    @Override
    public <E extends MTreeEntry> Assignments<E> distribute(AbstractNode<E> node, int routing1, double[] dis1, int routing2, double[] dis2) {
        int n = node.getNumEntries();
        int l = n - 2;
        assert (dis1.length == n && dis2.length == n);
        int[] idx1 = new int[l];
        int[] idx2 = new int[l];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if (i == routing1 || i == routing2) continue;
            idx1[j] = idx2[j] = i;
            ++j;
        }
        IntegerArrayQuickSort.sort(idx1, 0, l, (a, b) -> Double.compare(dis1[a], dis1[b]));
        IntegerArrayQuickSort.sort(idx2, 0, l, (a, b) -> Double.compare(dis2[a], dis2[b]));
        MTreeEntry e1 = (MTreeEntry)node.getEntry(routing1);
        MTreeEntry e2 = (MTreeEntry)node.getEntry(routing2);
        Assignments<MTreeEntry> assign = new Assignments<MTreeEntry>(e1.getRoutingObjectID(), e2.getRoutingObjectID(), n + 1 >> 1);
        assign.addToFirst(e1, 0.0);
        assign.addToSecond(e2, 0.0);
        boolean[] assigned = new boolean[n];
        int p1 = 0;
        block1: for (int p2 = 0; p1 < l && p2 < l; ++p1, ++p2) {
            int i2;
            int i1;
            while (assigned[i1 = idx1[p1]]) {
                if (++p1 < l) continue;
                break block1;
            }
            assign.addToFirst((MTreeEntry)node.getEntry(i1), dis1[i1]);
            assigned[i1] = true;
            while (assigned[i2 = idx2[p2]]) {
                if (++p2 < l) continue;
                break block1;
            }
            assign.addToSecond((MTreeEntry)node.getEntry(i2), dis2[i2]);
            assigned[i2] = true;
        }
        assert (assign.getFirstAssignments().size() + assign.getSecondAssignments().size() == n) : "Sizes do not sum up: " + assign.getFirstAssignments().size() + " + " + assign.getSecondAssignments().size() + " != " + n;
        assert (Math.abs(assign.getFirstAssignments().size() - assign.getSecondAssignments().size()) <= 1) : "Not balanced: " + assign.getFirstAssignments().size() + " " + assign.getSecondAssignments().size();
        return assign;
    }
}

