/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution;

import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;

public class FarthestBalancedDistribution
implements DistributionStrategy {
    @Override
    public <E extends MTreeEntry> Assignments<E> distribute(AbstractNode<E> node, int routing1, double[] dis1, int routing2, double[] dis2) {
        int n = node.getNumEntries();
        int l = n - 2;
        assert (dis1.length == n && dis2.length == n);
        int[] idx1 = new int[l];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if (i == routing1 || i == routing2) continue;
            idx1[j++] = i;
        }
        IntegerArrayQuickSort.sort(idx1, 0, l, (a, b) -> Double.compare(Math.max(dis1[b], dis2[b]), Math.max(dis1[a], dis2[a])));
        MTreeEntry e1 = (MTreeEntry)node.getEntry(routing1);
        MTreeEntry e2 = (MTreeEntry)node.getEntry(routing2);
        Assignments<MTreeEntry> assign = new Assignments<MTreeEntry>(e1.getRoutingObjectID(), e2.getRoutingObjectID(), n + 1 >> 1);
        assign.addToFirst(e1, 0.0);
        assign.addToSecond(e2, 0.0);
        int h = n + 1 >> 1;
        int s1 = 1;
        int s2 = 1;
        for (int p = 0; p < l; ++p) {
            int i = idx1[p];
            double d1 = dis1[i];
            double d2 = dis2[i];
            if (s2 == h || s1 != h && (d1 < d2 || d1 == d2 && s1 < s2)) {
                assign.addToFirst((MTreeEntry)node.getEntry(i), d1);
                ++s1;
                continue;
            }
            assign.addToSecond((MTreeEntry)node.getEntry(i), d2);
            ++s2;
        }
        assert (assign.getFirstAssignments().size() + assign.getSecondAssignments().size() == n) : "Sizes do not sum up: " + assign.getFirstAssignments().size() + " + " + assign.getSecondAssignments().size() + " != " + n;
        assert (Math.abs(assign.getFirstAssignments().size() - assign.getSecondAssignments().size()) <= 1) : "Not balanced: " + assign.getFirstAssignments().size() + " " + assign.getSecondAssignments().size();
        return assign;
    }
}

