/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution;

import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.Assignments;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.distribution.DistributionStrategy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="P. Ciaccia, M. Patella, P. Zezula", title="M-tree: An Efficient Access Method for Similarity Search in Metric Spaces", booktitle="Proc. Int. Conf. Very Large Data Bases (VLDB'97)", url="http://www.vldb.org/conf/1997/P426.PDF", bibkey="DBLP:conf/vldb/CiacciaPZ97")
public class GeneralizedHyperplaneDistribution
implements DistributionStrategy {
    @Override
    public <E extends MTreeEntry> Assignments<E> distribute(AbstractNode<E> node, int routing1, double[] dis1, int routing2, double[] dis2) {
        int n = node.getNumEntries();
        assert (dis1.length == n && dis2.length == n);
        MTreeEntry e1 = (MTreeEntry)node.getEntry(routing1);
        MTreeEntry e2 = (MTreeEntry)node.getEntry(routing2);
        Assignments<MTreeEntry> assign = new Assignments<MTreeEntry>(e1.getRoutingObjectID(), e2.getRoutingObjectID(), n - 1);
        assign.addToFirst(e1, 0.0);
        assign.addToSecond(e2, 0.0);
        int c1 = 1;
        int c2 = 1;
        for (int i = 0; i < n; ++i) {
            if (i == routing1 || i == routing2) continue;
            double d1 = dis1[i];
            double d2 = dis2[i];
            if (d1 < d2 || d1 == d2 && c1 < c2) {
                assign.addToFirst((MTreeEntry)node.getEntry(i), d1);
                ++c1;
                continue;
            }
            assign.addToSecond((MTreeEntry)node.getEntry(i), d2);
            ++c2;
        }
        assert (assign.getFirstAssignments().size() + assign.getSecondAssignments().size() == n) : "Sizes do not sum up: " + assign.getFirstAssignments().size() + " + " + assign.getSecondAssignments().size() + " != " + n;
        return assign;
    }
}

