/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SpatialPointLeafEntry
implements LeafEntry,
SpatialEntry,
NumberVector {
    private static final long serialVersionUID = 2L;
    private DBID id;
    private double[] values;

    public SpatialPointLeafEntry() {
    }

    public SpatialPointLeafEntry(DBID id, double[] values) {
        this.id = id;
        this.values = values;
    }

    public SpatialPointLeafEntry(DBID id, NumberVector vector) {
        this.id = id;
        int dim = vector.getDimensionality();
        this.values = new double[dim];
        for (int i = 0; i < dim; ++i) {
            this.values[i] = vector.doubleValue(i);
        }
    }

    @Override
    public DBID getDBID() {
        return this.id;
    }

    @Override
    public int getDimensionality() {
        return this.values.length;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(DBIDUtil.asInteger(this.id));
        out.writeInt(this.values.length);
        for (double v : this.values) {
            out.writeDouble(v);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = DBIDUtil.importInteger(in.read());
        this.values = new double[in.readInt()];
        for (int d = 0; d < this.values.length; ++d) {
            this.values[d] = in.readDouble();
        }
    }

    @Override
    public double doubleValue(int dimension) {
        return this.values[dimension];
    }

    @Override
    public long longValue(int dimension) {
        return (long)this.values[dimension];
    }

    @Override
    public double[] toArray() {
        return (double[])this.values.clone();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && DBIDUtil.equal(this.id, ((SpatialPointLeafEntry)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

