/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.kd;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.QuickSelectDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SparseLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="J. L. Bentley", title="Multidimensional binary search trees used for associative searching", booktitle="Communications of the ACM 18(9)", url="https://doi.org/10.1145/361002.361007", bibkey="DBLP:journals/cacm/Bentley75")
public class MinimalisticMemoryKDTree<O extends NumberVector>
extends AbstractIndex<O>
implements KNNIndex<O>,
RangeIndex<O> {
    private static final Logging LOG = Logging.getLogger(MinimalisticMemoryKDTree.class);
    ArrayModifiableDBIDs sorted = null;
    int dims = -1;
    int leafsize;
    final Counter objaccess;
    final Counter distcalc;

    public MinimalisticMemoryKDTree(Relation<O> relation, int leafsize) {
        super(relation);
        this.leafsize = leafsize;
        assert (leafsize >= 1);
        if (LOG.isStatistics()) {
            String prefix = this.getClass().getName();
            this.objaccess = LOG.newCounter(prefix + ".objaccess");
            this.distcalc = LOG.newCounter(prefix + ".distancecalcs");
        } else {
            this.objaccess = null;
            this.distcalc = null;
        }
    }

    @Override
    public void initialize() {
        this.sorted = DBIDUtil.newArray(this.relation.getDBIDs());
        this.dims = RelationUtil.dimensionality(this.relation);
        VectorUtil.SortDBIDsBySingleDimension comp = this.objaccess != null ? new CountSortAccesses(this.objaccess, this.relation) : new VectorUtil.SortDBIDsBySingleDimension(this.relation);
        this.buildTree(0, this.sorted.size(), 0, comp);
    }

    private void buildTree(int left, int right, int axis, VectorUtil.SortDBIDsBySingleDimension comp) {
        int middle = left + right >>> 1;
        comp.setDimension(axis);
        QuickSelectDBIDs.quickSelect(this.sorted, comp, left, right, middle);
        int next = (axis + 1) % this.dims;
        if (left + this.leafsize < middle) {
            this.buildTree(left, middle, next, comp);
        }
        if (++middle + this.leafsize < right) {
            this.buildTree(middle, right, next, comp);
        }
    }

    @Override
    public String getLongName() {
        return "kd-tree";
    }

    @Override
    public String getShortName() {
        return "kd-tree";
    }

    @Override
    public void logStatistics() {
        if (this.objaccess != null) {
            LOG.statistics(this.objaccess);
        }
        if (this.distcalc != null) {
            LOG.statistics(this.distcalc);
        }
    }

    protected void countObjectAccess() {
        if (this.objaccess != null) {
            this.objaccess.increment();
        }
    }

    protected void countDistanceComputation() {
        if (this.distcalc != null) {
            this.distcalc.increment();
        }
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        DistanceFunction<O> df = distanceQuery.getDistanceFunction();
        if (df instanceof LPNormDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)df);
        }
        if (df instanceof SquaredEuclideanDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)df);
        }
        if (df instanceof SparseLPNormDistanceFunction) {
            return new KDTreeKNNQuery(distanceQuery, (Norm)df);
        }
        return null;
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        DistanceFunction<O> df = distanceQuery.getDistanceFunction();
        if (df instanceof LPNormDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)df);
        }
        if (df instanceof SquaredEuclideanDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)df);
        }
        if (df instanceof SparseLPNormDistanceFunction) {
            return new KDTreeRangeQuery(distanceQuery, (Norm)df);
        }
        return null;
    }

    @Alias(value={"minikd"})
    public static class Factory<O extends NumberVector>
    implements IndexFactory<O> {
        int leafsize;

        public Factory() {
            this(1);
        }

        public Factory(int leafsize) {
            this.leafsize = leafsize;
        }

        public MinimalisticMemoryKDTree<O> instantiate(Relation<O> relation) {
            return new MinimalisticMemoryKDTree<O>(relation, this.leafsize);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer<O extends NumberVector>
        extends AbstractParameterizer {
            public static final OptionID LEAFSIZE_P = new OptionID("kd.leafsize", "Maximum leaf size for the k-d-tree. Nodes will be split until their size is smaller than this threshold.");
            int leafsize;

            @Override
            protected void makeOptions(Parameterization config) {
                super.makeOptions(config);
                IntParameter leafP = (IntParameter)new IntParameter(LEAFSIZE_P, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (config.grab(leafP)) {
                    this.leafsize = leafP.intValue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.leafsize);
            }
        }
    }

    public class KDTreeRangeQuery
    extends AbstractDistanceRangeQuery<O> {
        private Norm<? super O> norm;

        public KDTreeRangeQuery(DistanceQuery<O> distanceQuery, Norm<? super O> norm) {
            super(distanceQuery);
            this.norm = norm;
        }

        @Override
        public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList result) {
            this.kdRangeSearch(0, MinimalisticMemoryKDTree.this.sorted.size(), 0, obj, result, MinimalisticMemoryKDTree.this.sorted.iter(), range);
        }

        private void kdRangeSearch(int left, int right, int axis, O query, ModifiableDoubleDBIDList res, DBIDArrayIter iter, double radius) {
            if (right - left <= MinimalisticMemoryKDTree.this.leafsize) {
                iter.seek(left);
                while (iter.getOffset() < right) {
                    double dist = this.norm.distance(query, MinimalisticMemoryKDTree.this.relation.get(iter));
                    MinimalisticMemoryKDTree.this.countObjectAccess();
                    MinimalisticMemoryKDTree.this.countDistanceComputation();
                    if (dist <= radius) {
                        res.add(dist, iter);
                    }
                    iter.advance();
                }
                return;
            }
            int middle = left + right >>> 1;
            NumberVector split = (NumberVector)MinimalisticMemoryKDTree.this.relation.get(iter.seek(middle));
            MinimalisticMemoryKDTree.this.countObjectAccess();
            double delta = split.doubleValue(axis) - query.doubleValue(axis);
            boolean onleft = delta >= 0.0;
            boolean onright = delta <= 0.0;
            boolean close = Math.abs(delta) <= radius;
            int next = (axis + 1) % MinimalisticMemoryKDTree.this.dims;
            if (close) {
                double dist = this.norm.distance((NumberVector)query, split);
                MinimalisticMemoryKDTree.this.countDistanceComputation();
                if (dist <= radius) {
                    assert (iter.getOffset() == middle);
                    res.add(dist, iter);
                }
            }
            if (left < middle && (onleft || close)) {
                this.kdRangeSearch(left, middle, next, query, res, iter, radius);
            }
            if (middle + 1 < right && (onright || close)) {
                this.kdRangeSearch(middle + 1, right, next, query, res, iter, radius);
            }
        }
    }

    public class KDTreeKNNQuery
    extends AbstractDistanceKNNQuery<O> {
        private Norm<? super O> norm;

        public KDTreeKNNQuery(DistanceQuery<O> distanceQuery, Norm<? super O> norm) {
            super(distanceQuery);
            this.norm = norm;
        }

        @Override
        public KNNList getKNNForObject(O obj, int k) {
            KNNHeap knns = DBIDUtil.newHeap(k);
            this.kdKNNSearch(0, MinimalisticMemoryKDTree.this.sorted.size(), 0, obj, knns, MinimalisticMemoryKDTree.this.sorted.iter(), Double.POSITIVE_INFINITY);
            return knns.toKNNList();
        }

        private double kdKNNSearch(int left, int right, int axis, O query, KNNHeap knns, DBIDArrayIter iter, double maxdist) {
            if (right - left <= MinimalisticMemoryKDTree.this.leafsize) {
                iter.seek(left);
                while (iter.getOffset() < right) {
                    double dist = this.norm.distance(query, MinimalisticMemoryKDTree.this.relation.get(iter));
                    MinimalisticMemoryKDTree.this.countObjectAccess();
                    MinimalisticMemoryKDTree.this.countDistanceComputation();
                    if (dist <= maxdist) {
                        knns.insert(dist, iter);
                    }
                    maxdist = knns.getKNNDistance();
                    iter.advance();
                }
                return maxdist;
            }
            int middle = left + right >>> 1;
            NumberVector split = (NumberVector)MinimalisticMemoryKDTree.this.relation.get(iter.seek(middle));
            MinimalisticMemoryKDTree.this.countObjectAccess();
            double delta = split.doubleValue(axis) - query.doubleValue(axis);
            boolean onleft = delta >= 0.0;
            boolean onright = delta <= 0.0;
            int next = (axis + 1) % MinimalisticMemoryKDTree.this.dims;
            if (onleft && onright) {
                double dist = this.norm.distance((NumberVector)query, split);
                MinimalisticMemoryKDTree.this.countDistanceComputation();
                if (dist <= maxdist) {
                    assert (iter.getOffset() == middle);
                    knns.insert(dist, iter);
                    maxdist = knns.getKNNDistance();
                }
                if (left < middle) {
                    maxdist = this.kdKNNSearch(left, middle, next, query, knns, iter, maxdist);
                }
                if (middle + 1 < right) {
                    maxdist = this.kdKNNSearch(middle + 1, right, next, query, knns, iter, maxdist);
                }
            } else if (onleft) {
                if (left < middle) {
                    maxdist = this.kdKNNSearch(left, middle, next, query, knns, iter, maxdist);
                }
                if (Math.abs(delta) <= maxdist) {
                    double dist = this.norm.distance((NumberVector)query, split);
                    MinimalisticMemoryKDTree.this.countDistanceComputation();
                    if (dist <= maxdist) {
                        knns.insert(dist, iter.seek(middle));
                        maxdist = knns.getKNNDistance();
                    }
                }
                if (middle + 1 < right && Math.abs(delta) <= maxdist) {
                    maxdist = this.kdKNNSearch(middle + 1, right, next, query, knns, iter, maxdist);
                }
            } else {
                if (middle + 1 < right) {
                    maxdist = this.kdKNNSearch(middle + 1, right, next, query, knns, iter, maxdist);
                }
                if (Math.abs(delta) <= maxdist) {
                    double dist = this.norm.distance((NumberVector)query, split);
                    MinimalisticMemoryKDTree.this.countDistanceComputation();
                    if (dist <= maxdist) {
                        knns.insert(dist, iter.seek(middle));
                        maxdist = knns.getKNNDistance();
                    }
                }
                if (left < middle && Math.abs(delta) <= maxdist) {
                    maxdist = this.kdKNNSearch(left, middle, next, query, knns, iter, maxdist);
                }
            }
            return maxdist;
        }
    }

    private static class CountSortAccesses
    extends VectorUtil.SortDBIDsBySingleDimension {
        final Counter objaccess;

        public CountSortAccesses(Counter objaccess, Relation<? extends NumberVector> data) {
            super(data);
            this.objaccess = objaccess;
        }

        @Override
        public int compare(DBIDRef id1, DBIDRef id2) {
            this.objaccess.increment(2L);
            return super.compare(id1, id2);
        }
    }
}

