/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants;

import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.BreadthFirstEnumeration;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialIndexTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.RTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.util.NodeArrayAdapter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class AbstractRStarTree<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry, S extends RTreeSettings>
extends SpatialIndexTree<N, E> {
    protected static final boolean EXTRA_INTEGRITY_CHECKS = false;
    protected int height;
    public Statistics statistics = new Statistics();
    E lastInsertedEntry = null;
    protected S settings;

    public AbstractRStarTree(PageFile<N> pagefile, S settings) {
        super(pagefile);
        this.settings = settings;
    }

    protected IndexTreePath<E> findPathToObject(IndexTreePath<E> subtree, SpatialComparable mbr, DBIDRef id) {
        AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.getNode(subtree.getEntry());
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                if (!DBIDUtil.equal(((LeafEntry)node.getEntry(i)).getDBID(), id)) continue;
                return new IndexTreePath<E>(subtree, node.getEntry(i), i);
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                IndexTreePath<E> childSubtree;
                IndexTreePath<E> path;
                if (!SpatialUtil.intersects((SpatialComparable)node.getEntry(i), mbr) || (path = this.findPathToObject(childSubtree = new IndexTreePath<E>(subtree, node.getEntry(i), i), mbr, id)) == null) continue;
                return path;
            }
        }
        return null;
    }

    @Override
    public void insertLeaf(E leaf) {
        if (!this.initialized) {
            this.initialize(leaf);
        }
        ((RTreeSettings)this.settings).getOverflowTreatment().reinitialize();
        this.preInsert(leaf);
        this.insertLeafEntry(leaf);
        this.doExtraIntegrityChecks();
    }

    protected void insertLeafEntry(E entry) {
        this.lastInsertedEntry = entry;
        IndexTreePath subtree = this.choosePath(this.getRootPath(), (SpatialComparable)entry, this.height, 1);
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("insertion-subtree " + subtree);
        }
        AbstractRStarTreeNode parent = (AbstractRStarTreeNode)this.getNode(subtree.getEntry());
        parent.addLeafEntry(entry);
        this.writeNode(parent);
        this.adjustTree(subtree);
    }

    protected void insertDirectoryEntry(E entry, int depth) {
        this.lastInsertedEntry = entry;
        IndexTreePath subtree = this.choosePath(this.getRootPath(), (SpatialComparable)entry, depth, 1);
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("subtree " + subtree);
        }
        AbstractRStarTreeNode parent = (AbstractRStarTreeNode)this.getNode(subtree.getEntry());
        parent.addDirectoryEntry(entry);
        this.writeNode(parent);
        this.adjustTree(subtree);
    }

    protected void deletePath(IndexTreePath<E> deletionPath) {
        AbstractRStarTreeNode leaf = (AbstractRStarTreeNode)this.getNode(deletionPath.getParentPath().getEntry());
        int index = deletionPath.getIndex();
        SpatialEntry entry = (SpatialEntry)leaf.getEntry(index);
        leaf.deleteEntry(index);
        this.writeNode(leaf);
        Stack stack = new Stack();
        this.condenseTree(deletionPath.getParentPath(), stack);
        while (!stack.empty()) {
            int i;
            AbstractRStarTreeNode node = (AbstractRStarTreeNode)stack.pop();
            if (node.isLeaf()) {
                for (i = 0; i < node.getNumEntries(); ++i) {
                    ((RTreeSettings)this.settings).getOverflowTreatment().reinitialize();
                    this.insertLeafEntry((SpatialEntry)node.getEntry(i));
                }
            } else {
                for (i = 0; i < node.getNumEntries(); ++i) {
                    stack.push(this.getNode(node.getEntry(i)));
                }
            }
            this.deleteNode(node);
        }
        this.postDelete(entry);
        this.doExtraIntegrityChecks();
    }

    @Override
    public void initializeFromFile(TreeIndexHeader header, PageFile<N> file) {
        super.initializeFromFile(header, file);
        this.height = this.computeHeight();
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine(new StringBuilder(100).append(this.getClass()).append("\n height = ").append(this.height).toString());
        }
    }

    @Override
    protected void initializeCapacities(E exampleLeaf) {
        ObjectOutputStream oos;
        ByteArrayOutputStream baos;
        int cap;
        try {
            cap = 0;
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            SpatialPointLeafEntry sl = new SpatialPointLeafEntry(DBIDUtil.importInteger(0), new double[exampleLeaf.getDimensionality()]);
            while (baos.size() <= this.getPageSize()) {
                sl.writeExternal(oos);
                oos.flush();
                ++cap;
            }
            this.leafCapacity = cap - 1;
        }
        catch (IOException e) {
            throw new AbortException("Error determining page sizes.", e);
        }
        try {
            cap = 0;
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            ModifiableHyperBoundingBox hb = new ModifiableHyperBoundingBox(new double[exampleLeaf.getDimensionality()], new double[exampleLeaf.getDimensionality()]);
            SpatialDirectoryEntry sl = new SpatialDirectoryEntry(0, hb);
            while (baos.size() <= this.getPageSize()) {
                sl.writeExternal(oos);
                oos.flush();
                ++cap;
            }
            this.dirCapacity = cap - 1;
        }
        catch (IOException e) {
            throw new AbortException("Error determining page sizes.", e);
        }
        if (this.dirCapacity <= 2) {
            throw new IllegalArgumentException("Node size of " + this.getPageSize() + " bytes is chosen too small!");
        }
        Logging log = this.getLogger();
        if (this.dirCapacity < 10) {
            log.warning("Page size is choosen very small! Maximum number of entries in a directory node = " + this.dirCapacity);
        }
        this.dirMinimum = (int)Math.floor((double)this.dirCapacity * ((RTreeSettings)this.settings).relativeMinFill);
        if (this.dirMinimum < 1) {
            this.dirMinimum = 1;
        }
        if (this.leafCapacity <= 2) {
            throw new IllegalArgumentException("Node size of " + this.getPageSize() + " bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            log.warning("Page size is choosen very small! Maximum number of entries in a leaf node = " + this.leafCapacity);
        }
        this.leafMinimum = (int)Math.floor((double)this.leafCapacity * ((RTreeSettings)this.settings).relativeMinFill);
        if (this.leafMinimum < 1) {
            this.leafMinimum = 1;
        }
    }

    public boolean canBulkLoad() {
        return ((RTreeSettings)this.settings).bulkSplitter != null && !this.initialized;
    }

    protected List<E> createBulkLeafNodes(List<E> objects) {
        int minEntries = this.leafMinimum;
        int maxEntries = this.leafCapacity;
        ArrayList<E> result = new ArrayList<E>();
        List<List<E>> partitions = ((RTreeSettings)this.settings).bulkSplitter.partition(objects, minEntries, maxEntries);
        for (List<E> partition : partitions) {
            AbstractRStarTreeNode leafNode = (AbstractRStarTreeNode)this.createNewLeafNode();
            for (SpatialEntry o : partition) {
                leafNode.addLeafEntry(o);
            }
            this.writeNode(leafNode);
            result.add(this.createNewDirectoryEntry(leafNode));
            if (!this.getLogger().isDebugging()) continue;
            this.getLogger().debugFine("Created leaf page " + leafNode.getPageID());
        }
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("numDataPages = " + result.size());
        }
        return result;
    }

    protected abstract void bulkLoad(List<E> var1);

    public final int getHeight() {
        return this.height;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    protected abstract int computeHeight();

    protected abstract boolean hasOverflow(N var1);

    protected abstract boolean hasUnderflow(N var1);

    protected abstract E createNewDirectoryEntry(N var1);

    protected IndexTreePath<E> createNewRoot(N oldRoot, N newNode) {
        AbstractRStarTreeNode root = (AbstractRStarTreeNode)this.createNewDirectoryNode();
        this.writeNode(root);
        ((AbstractExternalizablePage)oldRoot).setPageID(root.getPageID());
        if (!((AbstractNode)oldRoot).isLeaf()) {
            for (int i = 0; i < ((AbstractNode)oldRoot).getNumEntries(); ++i) {
                this.writeNode(this.getNode(((AbstractNode)oldRoot).getEntry(i)));
            }
        }
        root.setPageID(this.getRootID());
        root.addDirectoryEntry(this.createNewDirectoryEntry(oldRoot));
        root.addDirectoryEntry(this.createNewDirectoryEntry(newNode));
        this.writeNode(root);
        this.writeNode(oldRoot);
        this.writeNode(newNode);
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("Create new Root: ID=" + root.getPageID() + "\nchild1 " + oldRoot + " " + new HyperBoundingBox((SpatialComparable)this.createNewDirectoryEntry(oldRoot)) + "\nchild2 " + newNode + " " + new HyperBoundingBox((SpatialComparable)this.createNewDirectoryEntry(newNode)));
        }
        return new IndexTreePath(null, this.getRootEntry(), -1);
    }

    protected IndexTreePath<E> containedTest(IndexTreePath<E> subtree, N node, SpatialComparable mbr) {
        SpatialEntry containingEntry = null;
        int index = -1;
        double cEVol = Double.NaN;
        for (int i = 0; i < ((AbstractNode)node).getNumEntries(); ++i) {
            SpatialEntry ei = (SpatialEntry)((AbstractNode)node).getEntry(i);
            if (!SpatialUtil.contains((SpatialComparable)ei, mbr)) continue;
            if (containingEntry == null) {
                containingEntry = ei;
                index = i;
                continue;
            }
            double tempVol = SpatialUtil.volume(ei);
            if (Double.isNaN(cEVol)) {
                cEVol = SpatialUtil.volume(containingEntry);
            }
            if (!(tempVol < cEVol)) continue;
            cEVol = tempVol;
            containingEntry = ei;
            index = i;
        }
        return containingEntry == null ? null : new IndexTreePath<Object>((IndexTreePath<Object>)subtree, containingEntry, index);
    }

    protected IndexTreePath<E> choosePath(IndexTreePath<E> subtree, SpatialComparable mbr, int depth, int cur) {
        AbstractRStarTreeNode node;
        if (this.getLogger().isDebuggingFiner()) {
            this.getLogger().debugFiner("node " + subtree + ", depth " + depth);
        }
        if ((node = (AbstractRStarTreeNode)this.getNode(subtree.getEntry())) == null) {
            throw new RuntimeException("Page file did not return node for node id: " + this.getPageID((Entry)subtree.getEntry()));
        }
        if (node.isLeaf()) {
            return subtree;
        }
        IndexTreePath<E> newSubtree = this.containedTest(subtree, node, mbr);
        if (newSubtree != null) {
            return ++cur == depth ? newSubtree : this.choosePath(newSubtree, mbr, depth, cur);
        }
        AbstractRStarTreeNode childNode = (AbstractRStarTreeNode)this.getNode(node.getEntry(0));
        int num = ((RTreeSettings)this.settings).insertionStrategy.choose(node, NodeArrayAdapter.STATIC, mbr, this.height, cur);
        newSubtree = new IndexTreePath<E>(subtree, node.getEntry(num), num);
        if (++cur == depth) {
            return newSubtree;
        }
        if (childNode.isLeaf()) {
            assert (cur == newSubtree.getPathCount());
            throw new IllegalArgumentException("childNode is leaf, but currentDepth != depth: " + cur + " != " + depth);
        }
        return this.choosePath(newSubtree, mbr, depth, cur);
    }

    private N overflowTreatment(N node, IndexTreePath<E> path) {
        if (((RTreeSettings)this.settings).getOverflowTreatment().handleOverflow(this, node, path)) {
            return null;
        }
        return this.split(node);
    }

    private N split(N node) {
        int minimum = ((AbstractNode)node).isLeaf() ? this.leafMinimum : this.dirMinimum;
        long[] split = ((RTreeSettings)this.settings).nodeSplitter.split(node, NodeArrayAdapter.STATIC, minimum);
        AbstractRStarTreeNode newNode = ((AbstractNode)node).isLeaf() ? (AbstractRStarTreeNode)this.createNewLeafNode() : (AbstractRStarTreeNode)this.createNewDirectoryNode();
        ((AbstractNode)node).splitByMask(newNode, split);
        this.writeNode(node);
        this.writeNode(newNode);
        return (N)newNode;
    }

    public void reInsert(N node, IndexTreePath<E> path, int[] offs) {
        int indexOfChild;
        AbstractRStarTreeNode parent;
        int depth = path.getPathCount();
        long[] remove = BitsUtil.zero(((AbstractNode)node).getCapacity());
        ArrayList reInsertEntries = new ArrayList(offs.length);
        for (int i = 0; i < offs.length; ++i) {
            reInsertEntries.add(((AbstractNode)node).getEntry(offs[i]));
            BitsUtil.setI(remove, offs[i]);
        }
        ((AbstractNode)node).removeMask(remove);
        this.writeNode(node);
        IndexTreePath<E> childPath = path;
        Object child = node;
        while (childPath.getParentPath() != null && ((AbstractRStarTreeNode)child).adjustEntry((SpatialEntry)((SpatialEntry)(parent = (AbstractRStarTreeNode)this.getNode(childPath.getParentPath().getEntry())).getEntry(indexOfChild = childPath.getIndex())))) {
            this.writeNode(parent);
            childPath = childPath.getParentPath();
            child = parent;
        }
        Logging log = this.getLogger();
        for (SpatialEntry entry : reInsertEntries) {
            if (((AbstractNode)node).isLeaf()) {
                if (log.isDebugging()) {
                    log.debug("reinsert " + entry);
                }
                this.insertLeafEntry(entry);
                continue;
            }
            if (log.isDebugging()) {
                log.debug("reinsert " + entry + " at " + depth);
            }
            this.insertDirectoryEntry(entry, depth);
        }
    }

    protected void adjustTree(IndexTreePath<E> subtree) {
        AbstractRStarTreeNode node;
        Logging log = this.getLogger();
        if (log.isDebugging()) {
            log.debugFine("Adjust tree " + subtree);
        }
        if (this.hasOverflow(node = (AbstractRStarTreeNode)this.getNode(subtree.getEntry()))) {
            AbstractRStarTreeNode split = this.overflowTreatment(node, subtree);
            if (split != null) {
                if (this.isRoot(node)) {
                    IndexTreePath<E> newRootPath = this.createNewRoot(node, split);
                    ++this.height;
                    this.adjustTree(newRootPath);
                } else {
                    AbstractRStarTreeNode parent = (AbstractRStarTreeNode)this.getNode(subtree.getParentPath().getEntry());
                    if (log.isDebugging()) {
                        log.debugFine("parent " + parent);
                    }
                    parent.addDirectoryEntry(this.createNewDirectoryEntry(split));
                    node.adjustEntry((SpatialEntry)parent.getEntry(subtree.getIndex()));
                    this.writeNode(parent);
                    this.adjustTree(subtree.getParentPath());
                }
            }
        } else if (!this.isRoot(node)) {
            AbstractRStarTreeNode parent = (AbstractRStarTreeNode)this.getNode(subtree.getParentPath().getEntry());
            SpatialEntry entry = (SpatialEntry)parent.getEntry(subtree.getIndex());
            boolean changed = node.adjustEntryIncremental(entry, (SpatialComparable)this.lastInsertedEntry);
            if (changed) {
                this.writeNode(parent);
                this.adjustTree(subtree.getParentPath());
            }
        } else {
            node.adjustEntry((SpatialEntry)this.getRootEntry());
        }
    }

    private void condenseTree(IndexTreePath<E> subtree, Stack<N> stack) {
        AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.getNode(subtree.getEntry());
        if (!this.isRoot(node)) {
            AbstractRStarTreeNode parent = (AbstractRStarTreeNode)this.getNode(subtree.getParentPath().getEntry());
            int index = subtree.getIndex();
            if (this.hasUnderflow(node)) {
                if (parent.deleteEntry(index)) {
                    stack.push(node);
                } else {
                    node.adjustEntry((SpatialEntry)parent.getEntry(index));
                }
            } else {
                node.adjustEntry((SpatialEntry)parent.getEntry(index));
            }
            this.writeNode(parent);
            this.condenseTree(subtree.getParentPath(), stack);
        } else if (this.hasUnderflow(node) && node.getNumEntries() == 1 && !node.isLeaf()) {
            AbstractRStarTreeNode newRoot;
            AbstractRStarTreeNode child = (AbstractRStarTreeNode)this.getNode(node.getEntry(0));
            if (child.isLeaf()) {
                newRoot = (AbstractRStarTreeNode)this.createNewLeafNode();
                newRoot.setPageID(this.getRootID());
                for (int i = 0; i < child.getNumEntries(); ++i) {
                    newRoot.addLeafEntry(child.getEntry(i));
                }
            } else {
                newRoot = (AbstractRStarTreeNode)this.createNewDirectoryNode();
                newRoot.setPageID(this.getRootID());
                for (int i = 0; i < child.getNumEntries(); ++i) {
                    newRoot.addDirectoryEntry(child.getEntry(i));
                }
            }
            this.writeNode(newRoot);
            --this.height;
        }
    }

    @Override
    public final List<E> getLeaves() {
        ArrayList result = new ArrayList();
        if (this.height == 1) {
            result.add(this.getRootEntry());
            return result;
        }
        this.getLeafNodes((AbstractRStarTreeNode)this.getRoot(), result, this.height);
        return result;
    }

    private void getLeafNodes(N node, List<E> result, int currentLevel) {
        if (currentLevel == 2) {
            for (int i = 0; i < ((AbstractNode)node).getNumEntries(); ++i) {
                result.add(((AbstractNode)node).getEntry(i));
            }
        } else {
            for (int i = 0; i < ((AbstractNode)node).getNumEntries(); ++i) {
                this.getLeafNodes((AbstractRStarTreeNode)this.getNode(((AbstractNode)node).getEntry(i)), result, currentLevel - 1);
            }
        }
    }

    public void doExtraIntegrityChecks() {
    }

    @Override
    public void logStatistics() {
        Logging log = this.getLogger();
        if (log.isStatistics()) {
            super.logStatistics();
            log.statistics(new LongStatistic(this.getClass().getName() + ".height", this.height));
            this.statistics.logStatistics();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int dirNodes = 0;
        int leafNodes = 0;
        int objects = 0;
        int levels = 0;
        if (this.initialized) {
            AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.getRoot();
            int dim = ((SpatialEntry)this.getRootEntry()).getDimensionality();
            while (!node.isLeaf()) {
                if (node.getNumEntries() <= 0) continue;
                SpatialEntry entry = (SpatialEntry)node.getEntry(0);
                node = (AbstractRStarTreeNode)this.getNode(entry);
                ++levels;
            }
            BreadthFirstEnumeration enumeration = new BreadthFirstEnumeration(this, this.getRootPath());
            while (enumeration.hasNext()) {
                Object indexPath = enumeration.next();
                SpatialEntry entry = (SpatialEntry)((IndexTreePath)indexPath).getEntry();
                if (entry instanceof LeafEntry) {
                    ++objects;
                    continue;
                }
                node = (AbstractRStarTreeNode)this.getNode(entry);
                if (node.isLeaf()) {
                    ++leafNodes;
                    continue;
                }
                ++dirNodes;
            }
            result.append(this.getClass().getName()).append(" has ").append(levels + 1).append(" levels.\n").append(dirNodes).append(" Directory Knoten (max = ").append(this.dirCapacity).append(", min = ").append(this.dirMinimum).append(")\n").append(leafNodes).append(" Daten Knoten (max = ").append(this.leafCapacity).append(", min = ").append(this.leafMinimum).append(")\n").append(objects).append(' ').append(dim).append("-dim. Punkte im Baum \n");
        } else {
            result.append(this.getClass().getName()).append(" is empty!\n");
        }
        return result.toString();
    }

    public class Statistics {
        protected final Counter distanceCalcs;
        protected final Counter knnQueries;
        protected final Counter rangeQueries;

        public Statistics() {
            Logging log = AbstractRStarTree.this.getLogger();
            String prefix = AbstractRStarTree.this.getClass().getName();
            this.distanceCalcs = log.isStatistics() ? log.newCounter(prefix + ".distancecalcs") : null;
            this.knnQueries = log.isStatistics() ? log.newCounter(prefix + ".knnqueries") : null;
            this.rangeQueries = log.isStatistics() ? log.newCounter(prefix + ".rangequeries") : null;
        }

        public void countDistanceCalculation() {
            if (this.distanceCalcs != null) {
                this.distanceCalcs.increment();
            }
        }

        public void countKNNQuery() {
            if (this.knnQueries != null) {
                this.knnQueries.increment();
            }
        }

        public void countRangeQuery() {
            if (this.rangeQueries != null) {
                this.rangeQueries.increment();
            }
        }

        public void logStatistics() {
            Logging log = AbstractRStarTree.this.getLogger();
            if (AbstractRStarTree.this.statistics.distanceCalcs != null) {
                log.statistics(AbstractRStarTree.this.statistics.distanceCalcs);
            }
            if (AbstractRStarTree.this.statistics.knnQueries != null) {
                log.statistics(AbstractRStarTree.this.statistics.knnQueries);
            }
            if (AbstractRStarTree.this.statistics.rangeQueries != null) {
                log.statistics(AbstractRStarTree.this.statistics.rangeQueries);
            }
        }
    }
}

