/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.index.PagedIndexFactory;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.RTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.bulk.BulkSplit;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.CombinedInsertionStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.insert.InsertionStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.overflow.LimitedReinsertOverflowTreatment;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.overflow.OverflowTreatment;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.TopologicalSplitter;
import de.lmu.ifi.dbs.elki.persistent.PageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractRStarTreeFactory<O extends NumberVector, N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry, S extends RTreeSettings>
extends PagedIndexFactory<O> {
    protected S settings;

    public AbstractRStarTreeFactory(PageFileFactory<?> pageFileFactory, S settings) {
        super(pageFileFactory);
        this.settings = settings;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return NumberVector.FIELD;
    }

    public static abstract class Parameterizer<O extends NumberVector, S extends RTreeSettings>
    extends PagedIndexFactory.Parameterizer<O> {
        public static OptionID INSERTION_STRATEGY_ID = new OptionID("rtree.insertionstrategy", "The strategy to use for object insertion.");
        public static OptionID SPLIT_STRATEGY_ID = new OptionID("rtree.splitstrategy", "The strategy to use for node splitting.");
        public static final OptionID BULK_SPLIT_ID = new OptionID("spatial.bulkstrategy", "The class to perform the bulk split with.");
        public static final OptionID MINIMUM_FILL_ID = new OptionID("rtree.minimum-fill", "Minimum relative fill required for data pages.");
        public static OptionID OVERFLOW_STRATEGY_ID = new OptionID("rtree.overflowtreatment", "The strategy to use for handling overflows.");
        protected S settings;

        protected abstract S createSettings();

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter overflowP;
            DoubleParameter minimumFillP;
            ObjectParameter splitStrategyP;
            super.makeOptions(config);
            this.settings = this.createSettings();
            ObjectParameter insertionStrategyP = new ObjectParameter(INSERTION_STRATEGY_ID, (Class<?>)InsertionStrategy.class, CombinedInsertionStrategy.class);
            if (config.grab(insertionStrategyP)) {
                ((RTreeSettings)this.settings).insertionStrategy = (InsertionStrategy)insertionStrategyP.instantiateClass(config);
            }
            if (config.grab(splitStrategyP = new ObjectParameter(SPLIT_STRATEGY_ID, (Class<?>)SplitStrategy.class, TopologicalSplitter.class))) {
                ((RTreeSettings)this.settings).nodeSplitter = (SplitStrategy)splitStrategyP.instantiateClass(config);
            }
            if (config.grab(minimumFillP = (DoubleParameter)((DoubleParameter)new DoubleParameter(MINIMUM_FILL_ID, 0.4).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_HALF_DOUBLE))) {
                ((RTreeSettings)this.settings).relativeMinFill = (Double)minimumFillP.getValue();
            }
            if (config.grab(overflowP = new ObjectParameter(OVERFLOW_STRATEGY_ID, (Class<?>)OverflowTreatment.class, LimitedReinsertOverflowTreatment.class))) {
                ((RTreeSettings)this.settings).setOverflowTreatment((OverflowTreatment)overflowP.instantiateClass(config));
            }
            this.configBulkLoad(config);
        }

        protected void configBulkLoad(Parameterization config) {
            ObjectParameter bulkSplitP = new ObjectParameter(BULK_SPLIT_ID, BulkSplit.class, true);
            if (config.grab(bulkSplitP)) {
                ((RTreeSettings)this.settings).bulkSplitter = (BulkSplit)bulkSplitP.instantiateClass(config);
            }
        }

        @Override
        protected abstract AbstractRStarTreeFactory<O, ?, ?, ?> makeInstance();
    }
}

