/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants;

import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Logger;

public abstract class AbstractRStarTreeNode<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry>
extends AbstractNode<E>
implements SpatialNode<N, E> {
    public AbstractRStarTreeNode() {
    }

    public AbstractRStarTreeNode(int capacity, boolean isLeaf) {
        super(capacity, isLeaf);
    }

    public ModifiableHyperBoundingBox computeMBR() {
        SpatialEntry firstEntry = (SpatialEntry)this.getEntry(0);
        if (firstEntry == null) {
            return null;
        }
        ModifiableHyperBoundingBox mbr = new ModifiableHyperBoundingBox(firstEntry);
        for (int i = 1; i < this.numEntries; ++i) {
            mbr.extend((SpatialComparable)this.getEntry(i));
        }
        return mbr;
    }

    public boolean adjustEntry(E entry) {
        SpatialDirectoryEntry se = (SpatialDirectoryEntry)entry;
        ModifiableHyperBoundingBox mbr = this.computeMBR();
        boolean changed = false;
        if (se.hasMBR()) {
            int dim = se.getDimensionality();
            for (int i = 0; i < dim; ++i) {
                if (Math.abs(se.getMin(i) - mbr.getMin(i)) > 1.1754943508222875E-38) {
                    changed = true;
                } else {
                    if (!(Math.abs(se.getMax(i) - mbr.getMax(i)) > 1.1754943508222875E-38)) continue;
                    changed = true;
                }
                break;
            }
        } else {
            changed = true;
        }
        if (changed) {
            se.setMBR(mbr);
        }
        return changed;
    }

    public boolean adjustEntryIncremental(E entry, SpatialComparable responsibleMBR) {
        return ((SpatialDirectoryEntry)entry).extendMBR(responsibleMBR);
    }

    public final void integrityCheck(AbstractRStarTree<N, E, ?> tree) {
        if (this.isLeaf()) {
            for (int i = 0; i < this.getCapacity(); ++i) {
                SpatialEntry e = (SpatialEntry)this.getEntry(i);
                if (i < this.getNumEntries() && e == null) {
                    throw new RuntimeException("i < numEntries && entry == null");
                }
                if (i < this.getNumEntries() || e == null) continue;
                throw new RuntimeException("i >= numEntries && entry != null");
            }
        } else {
            AbstractRStarTreeNode tmp = (AbstractRStarTreeNode)tree.getNode((SpatialEntry)this.getEntry(0));
            boolean childIsLeaf = tmp.isLeaf();
            for (int i = 0; i < this.getCapacity(); ++i) {
                SpatialEntry e = (SpatialEntry)this.getEntry(i);
                if (i < this.getNumEntries() && e == null) {
                    throw new RuntimeException("i < numEntries && entry == null");
                }
                if (i >= this.getNumEntries() && e != null) {
                    throw new RuntimeException("i >= numEntries && entry != null");
                }
                if (e == null) continue;
                AbstractRStarTreeNode node = (AbstractRStarTreeNode)tree.getNode(e);
                if (childIsLeaf && !node.isLeaf()) {
                    for (int k = 0; k < this.getNumEntries(); ++k) {
                        tree.getNode((SpatialEntry)this.getEntry(k));
                    }
                    throw new RuntimeException("Wrong Child in " + this + " at " + i);
                }
                if (!childIsLeaf && node.isLeaf()) {
                    throw new RuntimeException("Wrong Child: child id no leaf, but node is leaf!");
                }
                node.integrityCheckParameters(this, i);
                node.integrityCheck(tree);
            }
            if (LoggingConfiguration.DEBUG) {
                Logger.getLogger(this.getClass().getName()).fine("DirNode " + this.getPageID() + " ok!");
            }
        }
    }

    protected void integrityCheckParameters(N parent, int index) {
        SpatialEntry entry = (SpatialEntry)((AbstractNode)parent).getEntry(index);
        ModifiableHyperBoundingBox mbr = this.computeMBR();
        if (mbr == null) {
            return;
        }
        if (!SpatialUtil.equals(entry, mbr)) {
            String soll = mbr.toString();
            String ist = new HyperBoundingBox(entry).toString();
            throw new RuntimeException("Wrong MBR in node " + ((AbstractExternalizablePage)parent).getPageID() + " at index " + index + " (child " + entry + ")\nsoll: " + soll + ",\n ist: " + ist);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.entries.length);
        for (Entry entry : this.entries) {
            if (entry == null) break;
            entry.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int capacity = in.readInt();
        if (this.isLeaf()) {
            this.entries = new SpatialPointLeafEntry[capacity];
            for (int i = 0; i < this.numEntries; ++i) {
                SpatialPointLeafEntry s = new SpatialPointLeafEntry();
                s.readExternal(in);
                this.entries[i] = s;
            }
        } else {
            this.entries = new SpatialDirectoryEntry[capacity];
            for (int i = 0; i < this.numEntries; ++i) {
                SpatialDirectoryEntry s = new SpatialDirectoryEntry();
                s.readExternal(in);
                this.entries[i] = s;
            }
        }
    }
}

