/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants;

import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.RTreeSettings;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.ArrayList;
import java.util.List;

public abstract class NonFlatRStarTree<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry, S extends RTreeSettings>
extends AbstractRStarTree<N, E, S> {
    public NonFlatRStarTree(PageFile<N> pagefile, S settings) {
        super(pagefile, settings);
    }

    @Override
    protected boolean hasOverflow(N node) {
        if (((AbstractNode)node).isLeaf()) {
            return ((AbstractNode)node).getNumEntries() == this.leafCapacity;
        }
        return ((AbstractNode)node).getNumEntries() == this.dirCapacity;
    }

    @Override
    protected boolean hasUnderflow(N node) {
        if (((AbstractNode)node).isLeaf()) {
            return ((AbstractNode)node).getNumEntries() < this.leafMinimum;
        }
        return ((AbstractNode)node).getNumEntries() < this.dirMinimum;
    }

    @Override
    protected int computeHeight() {
        AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.getRoot();
        int height = 1;
        while (!node.isLeaf() && node.getNumEntries() != 0) {
            SpatialEntry entry = (SpatialEntry)node.getEntry(0);
            node = (AbstractRStarTreeNode)this.getNode(entry);
            ++height;
        }
        return height;
    }

    @Override
    protected void createEmptyRoot(E exampleLeaf) {
        AbstractRStarTreeNode root = (AbstractRStarTreeNode)this.createNewLeafNode();
        this.writeNode(root);
        this.setHeight(1);
    }

    @Override
    protected void bulkLoad(List<E> spatialObjects) {
        StringBuilder msg;
        if (!this.initialized) {
            this.initialize((Entry)spatialObjects.get(0));
        }
        StringBuilder stringBuilder = msg = this.getLogger().isDebuggingFine() ? new StringBuilder() : null;
        if (spatialObjects.size() <= this.leafCapacity) {
            AbstractRStarTreeNode root = (AbstractRStarTreeNode)this.createNewLeafNode();
            root.setPageID(this.getRootID());
            this.writeNode(root);
            this.createRoot(root, spatialObjects);
            this.setHeight(1);
            if (msg != null) {
                msg.append("\n  numNodes = 1");
            }
        } else {
            AbstractRStarTreeNode root = (AbstractRStarTreeNode)this.createNewDirectoryNode();
            root.setPageID(this.getRootID());
            this.writeNode(root);
            List<E> nodes = this.createBulkLeafNodes(spatialObjects);
            int numNodes = nodes.size();
            if (msg != null) {
                msg.append("\n  numLeafNodes = ").append(numNodes);
            }
            this.setHeight(1);
            while (nodes.size() > this.dirCapacity - 1) {
                nodes = this.createBulkDirectoryNodes(nodes);
                numNodes += nodes.size();
                this.setHeight(this.getHeight() + 1);
            }
            this.createRoot(root, nodes);
            ++numNodes;
            this.setHeight(this.getHeight() + 1);
            if (msg != null) {
                msg.append("\n  numNodes = ").append(numNodes);
            }
        }
        if (msg != null) {
            msg.append("\n  height = ").append(this.getHeight());
            msg.append("\n  root ").append(this.getRoot());
            this.getLogger().debugFine(msg.toString());
        }
    }

    private List<E> createBulkDirectoryNodes(List<E> nodes) {
        int minEntries = this.dirMinimum;
        int maxEntries = this.dirCapacity - 1;
        ArrayList result = new ArrayList();
        List<List<E>> partitions = this.settings.bulkSplitter.partition(nodes, minEntries, maxEntries);
        for (List<E> partition : partitions) {
            AbstractRStarTreeNode dirNode = (AbstractRStarTreeNode)this.createNewDirectoryNode();
            for (SpatialEntry o : partition) {
                dirNode.addDirectoryEntry(o);
            }
            this.writeNode(dirNode);
            result.add(this.createNewDirectoryEntry(dirNode));
            if (!this.getLogger().isDebuggingFiner()) continue;
            this.getLogger().debugFiner("Directory page no: " + dirNode.getPageID());
        }
        return result;
    }

    private N createRoot(N root, List<E> objects) {
        for (SpatialEntry entry : objects) {
            if (entry instanceof LeafEntry) {
                ((AbstractNode)root).addLeafEntry((SpatialEntry)entry);
                continue;
            }
            ((AbstractNode)root).addDirectoryEntry((SpatialEntry)entry);
        }
        ((SpatialDirectoryEntry)this.getRootEntry()).setMBR(((AbstractRStarTreeNode)root).computeMBR());
        this.writeNode(root);
        if (this.getLogger().isDebuggingFiner()) {
            StringBuilder msg = new StringBuilder();
            msg.append("pageNo ").append(((AbstractExternalizablePage)root).getPageID());
            this.getLogger().debugFiner(msg.toString());
        }
        return root;
    }
}

