/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu;

import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluEntry;

public class DeLiCluNode
extends AbstractRStarTreeNode<DeLiCluNode, DeLiCluEntry> {
    private static final long serialVersionUID = 1L;

    public DeLiCluNode() {
    }

    public DeLiCluNode(int capacity, boolean isLeaf) {
        super(capacity, isLeaf);
    }

    public boolean hasHandled() {
        for (int i = 0; i < this.getNumEntries(); ++i) {
            boolean handled = ((DeLiCluEntry)this.getEntry(i)).hasHandled();
            if (!handled) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnhandled() {
        for (int i = 0; i < this.getNumEntries(); ++i) {
            boolean handled = ((DeLiCluEntry)this.getEntry(i)).hasUnhandled();
            if (!handled) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean adjustEntry(DeLiCluEntry entry) {
        boolean changed = super.adjustEntry(entry);
        boolean hasHandled = this.hasHandled();
        boolean hasUnhandled = this.hasUnhandled();
        entry.setHasHandled(hasHandled);
        entry.setHasUnhandled(hasUnhandled);
        return changed;
    }

    @Override
    protected void integrityCheckParameters(DeLiCluNode parent, int index) {
        super.integrityCheckParameters(parent, index);
        DeLiCluEntry entry = (DeLiCluEntry)parent.getEntry(index);
        boolean hasHandled = this.hasHandled();
        boolean hasUnhandled = this.hasUnhandled();
        if (entry.hasHandled() != hasHandled) {
            String soll = Boolean.toString(hasHandled);
            String ist = Boolean.toString(entry.hasHandled());
            throw new RuntimeException("Wrong hasHandled in node " + parent.getPageID() + " at index " + index + " (child " + entry + ")\nsoll: " + soll + ",\n ist: " + ist);
        }
        if (entry.hasUnhandled() != hasUnhandled) {
            String soll = Boolean.toString(hasUnhandled);
            String ist = Boolean.toString(entry.hasUnhandled());
            throw new RuntimeException("Wrong hasUnhandled in node " + parent.getPageID() + " at index " + index + " (child " + entry + ")\nsoll: " + soll + ",\n ist: " + ist);
        }
    }
}

