/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.RTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.deliclu.DeLiCluTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;

public class DeLiCluTreeIndex<O extends NumberVector>
extends DeLiCluTree
implements KNNIndex<O>,
RangeIndex<O>,
DynamicIndex {
    private Relation<O> relation;
    private static final Logging LOG = Logging.getLogger(DeLiCluTreeIndex.class);

    public DeLiCluTreeIndex(Relation<O> relation, PageFile<DeLiCluNode> pagefile, RTreeSettings settings) {
        super(pagefile, settings);
        this.relation = relation;
    }

    protected DeLiCluLeafEntry createNewLeafEntry(DBID id) {
        return new DeLiCluLeafEntry(id, (NumberVector)this.relation.get(id));
    }

    public synchronized IndexTreePath<DeLiCluEntry> setHandled(DBID id, O obj) {
        IndexTreePath<DeLiCluEntry> pathToObject;
        if (LOG.isDebugging()) {
            LOG.debugFine("setHandled " + id + ", " + obj + "\n");
        }
        if ((pathToObject = this.findPathToObject(this.getRootPath(), (SpatialComparable)obj, id)) == null) {
            throw new AbortException("Object not found in setHandled.");
        }
        DeLiCluEntry entry = (DeLiCluEntry)pathToObject.getEntry();
        entry.setHasHandled(true);
        entry.setHasUnhandled(false);
        IndexTreePath<DeLiCluEntry> path = pathToObject;
        while (path.getParentPath() != null) {
            DeLiCluEntry parentEntry = (DeLiCluEntry)path.getParentPath().getEntry();
            DeLiCluNode node = (DeLiCluNode)this.getNode(parentEntry);
            boolean hasHandled = false;
            boolean hasUnhandled = false;
            for (int i = 0; i < node.getNumEntries(); ++i) {
                DeLiCluEntry nodeEntry = (DeLiCluEntry)node.getEntry(i);
                hasHandled = hasHandled || nodeEntry.hasHandled();
                hasUnhandled = hasUnhandled || nodeEntry.hasUnhandled();
            }
            parentEntry.setHasUnhandled(hasUnhandled);
            parentEntry.setHasHandled(hasHandled);
            path = path.getParentPath();
        }
        return pathToObject;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public final void insert(DBIDRef id) {
        this.insertLeaf(this.createNewLeafEntry(DBIDUtil.deref(id)));
    }

    @Override
    public final void insertAll(DBIDs ids) {
        if (ids.isEmpty() || ids.size() == 1) {
            return;
        }
        if (this.canBulkLoad()) {
            ArrayList<DeLiCluLeafEntry> leafs = new ArrayList<DeLiCluLeafEntry>(ids.size());
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                leafs.add(this.createNewLeafEntry(DBIDUtil.deref(iter)));
                iter.advance();
            }
            this.bulkLoad(leafs);
        } else {
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                this.insert(iter);
                iter.advance();
            }
        }
        this.doExtraIntegrityChecks();
    }

    @Override
    public final boolean delete(DBIDRef id) {
        NumberVector obj = (NumberVector)this.relation.get(id);
        IndexTreePath deletionPath = this.findPathToObject(this.getRootPath(), obj, id);
        if (deletionPath == null) {
            return false;
        }
        this.deletePath(deletionPath);
        return true;
    }

    @Override
    public void deleteAll(DBIDs ids) {
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.delete(DBIDUtil.deref(iter));
            iter.advance();
        }
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery dq = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getRangeQuery(this, dq, hints);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery dq = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getKNNQuery(this, dq, hints);
    }

    @Override
    public String getLongName() {
        return "DeLiClu-Tree";
    }

    @Override
    public String getShortName() {
        return "deliclutree";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

