/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.flat;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.RTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.flat.FlatRStarTreeNode;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.List;

public abstract class FlatRStarTree
extends AbstractRStarTree<FlatRStarTreeNode, SpatialEntry, RTreeSettings> {
    private static final Logging LOG = Logging.getLogger(FlatRStarTree.class);
    private FlatRStarTreeNode root;

    public FlatRStarTree(PageFile<FlatRStarTreeNode> pagefile, RTreeSettings settings) {
        super(pagefile, settings);
    }

    @Override
    public void initializeFromFile(TreeIndexHeader header, PageFile<FlatRStarTreeNode> file) {
        int nextPageID;
        super.initializeFromFile(header, file);
        this.dirCapacity = nextPageID = file.getNextPageID();
        this.root = this.createNewDirectoryNode();
        for (int i = 1; i < nextPageID; ++i) {
            FlatRStarTreeNode node = (FlatRStarTreeNode)this.getNode(i);
            this.root.addDirectoryEntry(this.createNewDirectoryEntry(node));
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("root: " + this.root + " with " + nextPageID + " leafNodes.");
        }
    }

    @Override
    public FlatRStarTreeNode getRoot() {
        return this.root;
    }

    @Override
    protected int computeHeight() {
        return 2;
    }

    @Override
    protected void bulkLoad(List<SpatialEntry> spatialObjects) {
        if (!this.initialized) {
            this.initialize((Entry)spatialObjects.get(0));
        }
        this.getFile().setNextPageID(this.getRootID() + 1);
        List<SpatialEntry> nodes = this.createBulkLeafNodes(spatialObjects);
        int numNodes = nodes.size();
        if (LOG.isDebugging()) {
            LOG.debugFine("  numLeafNodes = " + numNodes);
        }
        this.root = this.createNewDirectoryNode();
        this.root.setPageID(this.getRootID());
        for (SpatialEntry entry : nodes) {
            this.root.addDirectoryEntry(entry);
        }
        ++numNodes;
        this.setHeight(2);
        if (LOG.isDebugging()) {
            StringBuilder msg = new StringBuilder();
            msg.append("  root = ").append(this.getRoot());
            msg.append("\n  numNodes = ").append(numNodes);
            msg.append("\n  height = ").append(this.getHeight());
            LOG.debugFine(msg.toString() + "\n");
        }
        this.doExtraIntegrityChecks();
    }

    @Override
    protected void createEmptyRoot(SpatialEntry exampleLeaf) {
        this.root = this.createNewDirectoryNode();
        this.root.setPageID(this.getRootID());
        this.getFile().setNextPageID(this.getRootID() + 1);
        FlatRStarTreeNode leaf = this.createNewLeafNode();
        this.writeNode(leaf);
        ModifiableHyperBoundingBox mbr = new ModifiableHyperBoundingBox(new double[exampleLeaf.getDimensionality()], new double[exampleLeaf.getDimensionality()]);
        this.root.addDirectoryEntry(new SpatialDirectoryEntry(leaf.getPageID(), mbr));
        this.setHeight(2);
    }

    @Override
    protected boolean hasOverflow(FlatRStarTreeNode node) {
        if (node.isLeaf()) {
            return node.getNumEntries() == this.leafCapacity;
        }
        if (node.getNumEntries() == node.getCapacity()) {
            node.increaseEntries();
        }
        return false;
    }

    @Override
    protected boolean hasUnderflow(FlatRStarTreeNode node) {
        if (node.isLeaf()) {
            return node.getNumEntries() < this.leafMinimum;
        }
        return false;
    }

    @Override
    protected FlatRStarTreeNode createNewLeafNode() {
        return new FlatRStarTreeNode(this.leafCapacity, true);
    }

    @Override
    protected FlatRStarTreeNode createNewDirectoryNode() {
        return new FlatRStarTreeNode(this.dirCapacity, false);
    }

    @Override
    protected SpatialEntry createNewDirectoryEntry(FlatRStarTreeNode node) {
        return new SpatialDirectoryEntry(node.getPageID(), node.computeMBR());
    }

    @Override
    protected SpatialEntry createRootEntry() {
        return new SpatialDirectoryEntry(0, null);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

