/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.flat;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.RTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.flat.FlatRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.flat.FlatRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.ArrayList;
import java.util.List;

public class FlatRStarTreeIndex<O extends NumberVector>
extends FlatRStarTree
implements RangeIndex<O>,
KNNIndex<O>,
DynamicIndex {
    private Relation<O> relation;
    private static final Logging LOG = Logging.getLogger(FlatRStarTreeIndex.class);

    public FlatRStarTreeIndex(Relation<O> relation, PageFile<FlatRStarTreeNode> pagefile, RTreeSettings settings) {
        super(pagefile, settings);
        this.relation = relation;
    }

    protected SpatialEntry createNewLeafEntry(DBID id) {
        return new SpatialPointLeafEntry(id, (NumberVector)this.relation.get(id));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public final void insert(DBIDRef id) {
        this.insertLeaf(this.createNewLeafEntry(DBIDUtil.deref(id)));
    }

    @Override
    public final void insertAll(DBIDs ids) {
        if (ids.isEmpty() || ids.size() == 1) {
            return;
        }
        if (this.canBulkLoad()) {
            ArrayList<SpatialEntry> leafs = new ArrayList<SpatialEntry>(ids.size());
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                leafs.add(this.createNewLeafEntry(DBIDUtil.deref(iter)));
                iter.advance();
            }
            this.bulkLoad((List<SpatialEntry>)leafs);
        } else {
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                this.insert(iter);
                iter.advance();
            }
        }
        this.doExtraIntegrityChecks();
    }

    @Override
    public final boolean delete(DBIDRef id) {
        NumberVector obj = (NumberVector)this.relation.get(id);
        IndexTreePath deletionPath = this.findPathToObject(this.getRootPath(), obj, id);
        if (deletionPath == null) {
            return false;
        }
        this.deletePath(deletionPath);
        return true;
    }

    @Override
    public void deleteAll(DBIDs ids) {
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.delete(DBIDUtil.deref(iter));
            iter.advance();
        }
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery dq = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getRangeQuery(this, dq, hints);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery dq = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getKNNQuery(this, dq, hints);
    }

    @Override
    public String getLongName() {
        return "Flat R*-Tree";
    }

    @Override
    public String getShortName() {
        return "flatrstartree";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

