/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeKNNQuery;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleIntegerMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Reference(authors="G. R. Hjaltason, H. Samet", title="Ranking in spatial databases", booktitle="4th Symp. Advances in Spatial Databases (SSD'95)", url="https://doi.org/10.1007/3-540-60159-7_6", bibkey="DBLP:conf/ssd/HjaltasonS95")
public class EuclideanRStarTreeKNNQuery<O extends NumberVector>
extends RStarTreeKNNQuery<O> {
    private static final SquaredEuclideanDistanceFunction SQUARED = SquaredEuclideanDistanceFunction.STATIC;

    public EuclideanRStarTreeKNNQuery(AbstractRStarTree<?, ?, ?> tree, Relation<? extends O> relation) {
        super(tree, relation, EuclideanDistanceFunction.STATIC);
    }

    @Override
    public KNNList getKNNForObject(O obj, int k) {
        double mindist;
        if (k < 1) {
            throw new IllegalArgumentException("At least one neighbor has to be requested!");
        }
        this.tree.statistics.countKNNQuery();
        KNNHeap knnList = DBIDUtil.newHeap(k);
        DoubleIntegerMinHeap pq = new DoubleIntegerMinHeap(Math.min(knnList.getK() << 1, 21));
        double maxDist = this.expandNode(obj, knnList, pq, Double.MAX_VALUE, this.tree.getRootID());
        while (!pq.isEmpty() && !((mindist = pq.peekKey()) > maxDist)) {
            int nodeID = pq.peekValue();
            pq.poll();
            maxDist = this.expandNode(obj, knnList, pq, maxDist, nodeID);
        }
        return knnList.toKNNListSqrt();
    }

    private double expandNode(O object, KNNHeap knnList, DoubleIntegerMinHeap pq, double maxDist, int nodeID) {
        AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.tree.getNode(nodeID);
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                SpatialPointLeafEntry entry = (SpatialPointLeafEntry)node.getEntry(i);
                double distance = SQUARED.minDist(entry, (SpatialComparable)object);
                this.tree.statistics.countDistanceCalculation();
                if (!(distance <= maxDist)) continue;
                maxDist = knnList.insert(distance, entry.getDBID());
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                SpatialDirectoryEntry entry = (SpatialDirectoryEntry)node.getEntry(i);
                double distance = SQUARED.minDist(entry, (SpatialComparable)object);
                this.tree.statistics.countDistanceCalculation();
                if (distance <= 0.0) {
                    this.expandNode(object, knnList, pq, maxDist, entry.getPageID());
                    continue;
                }
                if (!(distance <= maxDist)) continue;
                pq.add(distance, entry.getPageID());
            }
        }
        return maxDist;
    }

    @Override
    public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("At least one enumeration has to be requested!");
        }
        HashMap<DBID, KNNHeap> knnLists = new HashMap<DBID, KNNHeap>(ids.size());
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref(iter);
            knnLists.put(id, DBIDUtil.newHeap(k));
            iter.advance();
        }
        this.batchNN((AbstractRStarTreeNode)this.tree.getRoot(), knnLists);
        ArrayList<KNNList> result = new ArrayList<KNNList>();
        DBIDArrayIter iter2 = ids.iter();
        while (iter2.valid()) {
            DBID id = DBIDUtil.deref(iter2);
            this.tree.statistics.countKNNQuery();
            result.add(((KNNHeap)knnLists.get(id)).toKNNListSqrt());
            iter2.advance();
        }
        return result;
    }
}

