/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeRangeQuery;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;
import net.jafama.FastMath;

@Reference(authors="J. Kuan, P. Lewis", title="Fast k nearest neighbour search for R-tree family", booktitle="Proc. Int. Conf Information, Communications and Signal Processing, ICICS 1997", url="https://doi.org/10.1109/ICICS.1997.652114", bibkey="doi:10.1109/ICICS.1997.652114")
public class EuclideanRStarTreeRangeQuery<O extends NumberVector>
extends RStarTreeRangeQuery<O> {
    private static final SquaredEuclideanDistanceFunction SQUARED = SquaredEuclideanDistanceFunction.STATIC;

    public EuclideanRStarTreeRangeQuery(AbstractRStarTree<?, ?, ?> tree, Relation<? extends O> relation) {
        super(tree, relation, EuclideanDistanceFunction.STATIC);
    }

    @Override
    public void getRangeForObject(O object, double range, ModifiableDoubleDBIDList result) {
        this.tree.statistics.countRangeQuery();
        double sqepsilon = range * range;
        int[] pq = new int[101];
        int ps = 0;
        pq[ps++] = this.tree.getRootID();
        while (ps > 0) {
            double distance;
            SpatialEntry entry;
            int i;
            int pqNode = pq[--ps];
            AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.tree.getNode(pqNode);
            int numEntries = node.getNumEntries();
            if (node.isLeaf()) {
                for (i = 0; i < numEntries; ++i) {
                    entry = (SpatialPointLeafEntry)node.getEntry(i);
                    distance = SQUARED.minDist((SpatialComparable)object, entry);
                    this.tree.statistics.countDistanceCalculation();
                    if (!(distance <= sqepsilon)) continue;
                    result.add(FastMath.sqrt(distance), ((SpatialPointLeafEntry)entry).getDBID());
                }
                continue;
            }
            for (i = 0; i < numEntries; ++i) {
                entry = (SpatialDirectoryEntry)node.getEntry(i);
                distance = SQUARED.minDist((SpatialComparable)object, entry);
                if (!(distance <= sqepsilon)) continue;
                if (ps == pq.length) {
                    pq = Arrays.copyOf(pq, pq.length + (pq.length >>> 1));
                }
                pq[ps++] = ((SpatialDirectoryEntry)entry).getPageID();
            }
        }
    }
}

