/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.DirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleIntegerMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Reference(authors="G. R. Hjaltason, H. Samet", title="Ranking in spatial databases", booktitle="4th Symp. Advances in Spatial Databases (SSD'95)", url="https://doi.org/10.1007/3-540-60159-7_6", bibkey="DBLP:conf/ssd/HjaltasonS95")
public class RStarTreeKNNQuery<O extends SpatialComparable>
implements KNNQuery<O> {
    protected final AbstractRStarTree<?, ?, ?> tree;
    protected final SpatialPrimitiveDistanceFunction<? super O> distanceFunction;
    protected Relation<? extends O> relation;

    public RStarTreeKNNQuery(AbstractRStarTree<?, ?, ?> tree, Relation<? extends O> relation, SpatialPrimitiveDistanceFunction<? super O> distanceFunction) {
        this.relation = relation;
        this.tree = tree;
        this.distanceFunction = distanceFunction;
    }

    @Override
    public KNNList getKNNForDBID(DBIDRef id, int k) {
        return this.getKNNForObject((O)((SpatialComparable)this.relation.get(id)), k);
    }

    @Override
    public KNNList getKNNForObject(O obj, int k) {
        double mindist;
        if (k < 1) {
            throw new IllegalArgumentException("At least one neighbor has to be requested!");
        }
        this.tree.statistics.countKNNQuery();
        KNNHeap knnList = DBIDUtil.newHeap(k);
        DoubleIntegerMinHeap pq = new DoubleIntegerMinHeap(Math.min(knnList.getK() << 1, 21));
        double maxDist = this.expandNode(obj, knnList, pq, Double.MAX_VALUE, this.tree.getRootID());
        while (!pq.isEmpty() && !((mindist = pq.peekKey()) > maxDist)) {
            int nodeID = pq.peekValue();
            pq.poll();
            maxDist = this.expandNode(obj, knnList, pq, maxDist, nodeID);
        }
        return knnList.toKNNList();
    }

    private double expandNode(O object, KNNHeap knnList, DoubleIntegerMinHeap pq, double maxDist, int nodeID) {
        AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.tree.getNode(nodeID);
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                SpatialPointLeafEntry entry = (SpatialPointLeafEntry)node.getEntry(i);
                double distance = this.distanceFunction.minDist(entry, (SpatialComparable)object);
                this.tree.statistics.countDistanceCalculation();
                if (!(distance <= maxDist)) continue;
                maxDist = knnList.insert(distance, entry.getDBID());
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                SpatialDirectoryEntry entry = (SpatialDirectoryEntry)node.getEntry(i);
                double distance = this.distanceFunction.minDist(entry, (SpatialComparable)object);
                this.tree.statistics.countDistanceCalculation();
                if (distance <= 0.0) {
                    this.expandNode(object, knnList, pq, maxDist, entry.getPageID());
                    continue;
                }
                if (!(distance <= maxDist)) continue;
                pq.add(distance, entry.getPageID());
            }
        }
        return maxDist;
    }

    protected void batchNN(AbstractRStarTreeNode<?, ?> node, Map<DBID, KNNHeap> knnLists) {
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                SpatialEntry p = (SpatialEntry)node.getEntry(i);
                for (Map.Entry<DBID, KNNHeap> ent : knnLists.entrySet()) {
                    DBID q = ent.getKey();
                    KNNHeap knns_q = ent.getValue();
                    double knn_q_maxDist = knns_q.getKNNDistance();
                    DBID pid = ((LeafEntry)((Object)p)).getDBID();
                    double dist_pq = this.distanceFunction.distance(this.relation.get(pid), this.relation.get(q));
                    this.tree.statistics.countDistanceCalculation();
                    if (!(dist_pq <= knn_q_maxDist)) continue;
                    knns_q.insert(dist_pq, pid);
                }
            }
        } else {
            ArrayModifiableDBIDs ids = DBIDUtil.newArray(knnLists.size());
            for (DBID id : knnLists.keySet()) {
                ids.add(id);
            }
            List<DoubleDistanceEntry> entries = this.getSortedEntries(node, ids);
            block3: for (DoubleDistanceEntry distEntry : entries) {
                double minDist = distEntry.distance;
                for (Map.Entry<DBID, KNNHeap> ent : knnLists.entrySet()) {
                    KNNHeap knns_q = ent.getValue();
                    double knn_q_maxDist = knns_q.getKNNDistance();
                    if (!(minDist <= knn_q_maxDist)) continue;
                    SpatialEntry entry = distEntry.entry;
                    AbstractRStarTreeNode child = (AbstractRStarTreeNode)this.tree.getNode(((DirectoryEntry)((Object)entry)).getPageID());
                    this.batchNN(child, knnLists);
                    continue block3;
                }
            }
        }
    }

    protected List<DoubleDistanceEntry> getSortedEntries(AbstractRStarTreeNode<?, ?> node, DBIDs ids) {
        ArrayList<DoubleDistanceEntry> result = new ArrayList<DoubleDistanceEntry>();
        for (int i = 0; i < node.getNumEntries(); ++i) {
            SpatialEntry entry = (SpatialEntry)node.getEntry(i);
            double minMinDist = Double.MAX_VALUE;
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                double minDist = this.distanceFunction.minDist(entry, (SpatialComparable)this.relation.get(iter));
                this.tree.statistics.countDistanceCalculation();
                minMinDist = Math.min(minDist, minMinDist);
                iter.advance();
            }
            result.add(new DoubleDistanceEntry(entry, minMinDist));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("At least one enumeration has to be requested!");
        }
        HashMap<DBID, KNNHeap> knnLists = new HashMap<DBID, KNNHeap>(ids.size());
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            DBID id = DBIDUtil.deref(iter);
            knnLists.put(id, DBIDUtil.newHeap(k));
            iter.advance();
        }
        this.batchNN((AbstractRStarTreeNode)this.tree.getRoot(), knnLists);
        ArrayList<KNNList> result = new ArrayList<KNNList>();
        DBIDArrayIter iter2 = ids.iter();
        while (iter2.valid()) {
            DBID id = DBIDUtil.deref(iter2);
            this.tree.statistics.countKNNQuery();
            result.add(((KNNHeap)knnLists.get(id)).toKNNList());
            iter2.advance();
        }
        return result;
    }

    private static class DoubleDistanceEntry
    implements Comparable<DoubleDistanceEntry> {
        SpatialEntry entry;
        double distance;

        public DoubleDistanceEntry(SpatialEntry entry, double distance) {
            this.entry = entry;
            this.distance = distance;
        }

        @Override
        public int compareTo(DoubleDistanceEntry o) {
            return Double.compare(this.distance, o.distance);
        }
    }
}

