/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="J. Kuan, P. Lewis", title="Fast k nearest neighbour search for R-tree family", booktitle="Proc. Int. Conf Information, Communications and Signal Processing, ICICS 1997", url="https://doi.org/10.1109/ICICS.1997.652114", bibkey="doi:10.1109/ICICS.1997.652114")
public class RStarTreeRangeQuery<O extends SpatialComparable>
implements RangeQuery<O> {
    protected final AbstractRStarTree<?, ?, ?> tree;
    protected final SpatialPrimitiveDistanceFunction<? super O> distanceFunction;
    protected Relation<? extends O> relation;

    public RStarTreeRangeQuery(AbstractRStarTree<?, ?, ?> tree, Relation<? extends O> relation, SpatialPrimitiveDistanceFunction<? super O> distanceFunction) {
        this.relation = relation;
        this.tree = tree;
        this.distanceFunction = distanceFunction;
    }

    @Override
    public DoubleDBIDList getRangeForDBID(DBIDRef id, double range) {
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        this.getRangeForObject((O)((SpatialComparable)this.relation.get(id)), range, result);
        result.sort();
        return result;
    }

    @Override
    public DoubleDBIDList getRangeForObject(O obj, double range) {
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        this.getRangeForObject(obj, range, result);
        result.sort();
        return result;
    }

    @Override
    public void getRangeForDBID(DBIDRef id, double range, ModifiableDoubleDBIDList result) {
        this.getRangeForObject((O)((SpatialComparable)this.relation.get(id)), range, result);
    }

    @Override
    public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList result) {
        this.tree.statistics.countRangeQuery();
        int[] pq = new int[101];
        int ps = 0;
        pq[ps++] = this.tree.getRootID();
        while (ps > 0) {
            double distance;
            SpatialEntry entry;
            int i;
            int pqNode = pq[--ps];
            AbstractRStarTreeNode node = (AbstractRStarTreeNode)this.tree.getNode(pqNode);
            int numEntries = node.getNumEntries();
            if (node.isLeaf()) {
                for (i = 0; i < numEntries; ++i) {
                    entry = (SpatialPointLeafEntry)node.getEntry(i);
                    distance = this.distanceFunction.minDist((SpatialComparable)obj, entry);
                    this.tree.statistics.countDistanceCalculation();
                    if (!(distance <= range)) continue;
                    result.add(distance, ((SpatialPointLeafEntry)entry).getDBID());
                }
                continue;
            }
            for (i = 0; i < numEntries; ++i) {
                entry = (SpatialDirectoryEntry)node.getEntry(i);
                distance = this.distanceFunction.minDist((SpatialComparable)obj, entry);
                if (!(distance <= range)) continue;
                if (ps == pq.length) {
                    pq = Arrays.copyOf(pq, pq.length + (pq.length >>> 1));
                }
                pq[ps++] = ((SpatialDirectoryEntry)entry).getPageID();
            }
        }
    }
}

