/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.EuclideanRStarTreeKNNQuery;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.EuclideanRStarTreeRangeQuery;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeKNNQuery;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeRangeQuery;

public final class RStarTreeUtil {
    private RStarTreeUtil() {
    }

    public static <O extends SpatialComparable> RangeQuery<O> getRangeQuery(AbstractRStarTree<?, ?, ?> tree, SpatialDistanceQuery<O> distanceQuery, Object ... hints) {
        DistanceFunction df = distanceQuery.getDistanceFunction();
        if (EuclideanDistanceFunction.STATIC.equals(df)) {
            return new EuclideanRStarTreeRangeQuery(tree, distanceQuery.getRelation());
        }
        return new RStarTreeRangeQuery(tree, distanceQuery.getRelation(), df);
    }

    public static <O extends SpatialComparable> KNNQuery<O> getKNNQuery(AbstractRStarTree<?, ?, ?> tree, SpatialDistanceQuery<O> distanceQuery, Object ... hints) {
        DistanceFunction df = distanceQuery.getDistanceFunction();
        if (EuclideanDistanceFunction.STATIC.equals(df)) {
            return new EuclideanRStarTreeKNNQuery(tree, distanceQuery.getRelation());
        }
        return new RStarTreeKNNQuery(tree, distanceQuery.getRelation(), df);
    }
}

