/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn;

import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNEntry;

public class RdKNNNode
extends AbstractRStarTreeNode<RdKNNNode, RdKNNEntry> {
    private static final long serialVersionUID = 1L;

    public RdKNNNode() {
    }

    public RdKNNNode(int capacity, boolean isLeaf) {
        super(capacity, isLeaf);
    }

    protected double kNNDistance() {
        double result = ((RdKNNEntry)this.getEntry(0)).getKnnDistance();
        for (int i = 1; i < this.getNumEntries(); ++i) {
            double knnDistance = ((RdKNNEntry)this.getEntry(i)).getKnnDistance();
            result = result < knnDistance ? knnDistance : result;
        }
        return result;
    }

    @Override
    public boolean adjustEntry(RdKNNEntry entry) {
        boolean changed = super.adjustEntry(entry);
        entry.setKnnDistance(this.kNNDistance());
        return changed;
    }

    @Override
    protected void integrityCheckParameters(RdKNNNode parent, int index) {
        super.integrityCheckParameters(parent, index);
        RdKNNEntry entry = (RdKNNEntry)parent.getEntry(index);
        double knnDistance = this.kNNDistance();
        if (entry.getKnnDistance() != knnDistance) {
            double soll = knnDistance;
            double ist = entry.getKnnDistance();
            throw new RuntimeException("Wrong knnDistance in node " + parent.getPageID() + " at index " + index + " (child " + entry + ")\nsoll: " + soll + ",\n ist: " + ist);
        }
    }
}

