/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.SpatialPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.NonFlatRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdKNNTreeHeader;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rdknn.RdkNNSettings;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleObjPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RdKNNTree<O extends NumberVector>
extends NonFlatRStarTree<RdKNNNode, RdKNNEntry, RdkNNSettings>
implements RangeIndex<O>,
KNNIndex<O>,
RKNNIndex<O>,
DynamicIndex {
    private static final Logging LOG = Logging.getLogger(RdKNNTree.class);
    private SpatialDistanceQuery<O> distanceQuery;
    protected KNNQuery<O> knnQuery;
    private Relation<O> relation;

    public RdKNNTree(Relation<O> relation, PageFile<RdKNNNode> pagefile, RdkNNSettings settings) {
        super(pagefile, settings);
        this.relation = relation;
        this.distanceQuery = settings.distanceFunction.instantiate(relation);
        this.knnQuery = relation.getKNNQuery(this.distanceQuery, new Object[0]);
    }

    @Override
    protected void preInsert(RdKNNEntry entry) {
        KNNHeap knns_o = DBIDUtil.newHeap(((RdkNNSettings)this.settings).k_max);
        this.preInsert(entry, (RdKNNEntry)this.getRootEntry(), knns_o);
    }

    @Override
    protected void postDelete(RdKNNEntry entry) {
        ModifiableDoubleDBIDList rnns = DBIDUtil.newDistanceDBIDList();
        this.doReverseKNN((RdKNNNode)this.getRoot(), ((RdKNNLeafEntry)entry).getDBID(), rnns);
        ArrayModifiableDBIDs ids = DBIDUtil.newArray(rnns);
        ids.sort();
        List<KNNList> knnLists = this.knnQuery.getKNNForBulkDBIDs(ids, ((RdkNNSettings)this.settings).k_max);
        this.adjustKNNDistance((RdKNNEntry)this.getRootEntry(), ids, knnLists);
    }

    @Override
    protected void bulkLoad(List<RdKNNEntry> entries) {
        super.bulkLoad(entries);
        ArrayModifiableDBIDs ids = DBIDUtil.newArray(entries.size());
        for (RdKNNEntry entry : entries) {
            DBID id = ((RdKNNLeafEntry)entry).getDBID();
            ids.add(id);
        }
        ids.sort();
        List<KNNList> knnLists = this.knnQuery.getKNNForBulkDBIDs(ids, ((RdkNNSettings)this.settings).k_max);
        this.adjustKNNDistance((RdKNNEntry)this.getRootEntry(), ids, knnLists);
        this.doExtraIntegrityChecks();
    }

    public DoubleDBIDList reverseKNNQuery(DBID oid, int k, SpatialPrimitiveDistanceFunction<? super O> distanceFunction, KNNQuery<O> knnQuery) {
        this.checkDistanceFunction(distanceFunction);
        if (k > ((RdkNNSettings)this.settings).k_max) {
            throw new IllegalArgumentException("Parameter k is not supported, k > k_max: " + k + " > " + ((RdkNNSettings)this.settings).k_max);
        }
        ModifiableDoubleDBIDList candidates = DBIDUtil.newDistanceDBIDList();
        this.doReverseKNN((RdKNNNode)this.getRoot(), oid, candidates);
        if (k == ((RdkNNSettings)this.settings).k_max) {
            candidates.sort();
            return candidates;
        }
        ArrayModifiableDBIDs candidateIDs = DBIDUtil.newArray(candidates);
        candidateIDs.sort();
        List<KNNList> knnLists = knnQuery.getKNNForBulkDBIDs(candidateIDs, k);
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        int i = 0;
        DBIDArrayMIter iter = candidateIDs.iter();
        while (iter.valid()) {
            DoubleDBIDListIter qr = knnLists.get(i).iter();
            while (qr.valid()) {
                if (DBIDUtil.equal(oid, qr)) {
                    result.add(qr.doubleValue(), iter);
                    break;
                }
                qr.advance();
            }
            iter.advance();
            ++i;
        }
        result.sort();
        return result;
    }

    public List<ModifiableDoubleDBIDList> bulkReverseKNNQueryForID(DBIDs ids, int k, SpatialPrimitiveDistanceFunction<? super O> distanceFunction, KNNQuery<O> knnQuery) {
        this.checkDistanceFunction(distanceFunction);
        if (k > ((RdkNNSettings)this.settings).k_max) {
            throw new IllegalArgumentException("Parameter k is not supported, k > k_max: " + k + " > " + ((RdkNNSettings)this.settings).k_max);
        }
        HashMap<DBID, ModifiableDoubleDBIDList> candidateMap = new HashMap<DBID, ModifiableDoubleDBIDList>();
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            Iterator id = DBIDUtil.deref(iter);
            candidateMap.put((DBID)((Object)id), DBIDUtil.newDistanceDBIDList());
            iter.advance();
        }
        this.doBulkReverseKNN((RdKNNNode)this.getRoot(), ids, candidateMap);
        if (k == ((RdkNNSettings)this.settings).k_max) {
            ArrayList<ModifiableDoubleDBIDList> resultList = new ArrayList<ModifiableDoubleDBIDList>();
            for (ModifiableDoubleDBIDList candidates : candidateMap.values()) {
                candidates.sort();
                resultList.add(candidates);
            }
            return resultList;
        }
        ArrayModifiableDBIDs candidateIDs = DBIDUtil.newArray();
        for (ModifiableDoubleDBIDList candidates : candidateMap.values()) {
            candidateIDs.addDBIDs(candidates);
        }
        candidateIDs.sort();
        List<KNNList> knnLists = knnQuery.getKNNForBulkDBIDs(candidateIDs, k);
        ArrayList<ModifiableDoubleDBIDList> resultList = new ArrayList<ModifiableDoubleDBIDList>();
        for (DBID id : candidateMap.keySet()) {
            ModifiableDoubleDBIDList candidates = (ModifiableDoubleDBIDList)candidateMap.get(id);
            ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
            DoubleDBIDListMIter candidate = candidates.iter();
            while (candidate.valid()) {
                int pos = candidateIDs.binarySearch(candidate);
                assert (pos >= 0);
                DoubleDBIDListIter qr = knnLists.get(pos).iter();
                while (qr.valid()) {
                    if (DBIDUtil.equal(id, qr)) {
                        result.add(qr.doubleValue(), candidate);
                        break;
                    }
                    qr.advance();
                }
                candidate.advance();
            }
            resultList.add(result);
        }
        return resultList;
    }

    @Override
    protected TreeIndexHeader createHeader() {
        return new RdKNNTreeHeader(this.getPageSize(), this.dirCapacity, this.leafCapacity, this.dirMinimum, this.leafCapacity, ((RdkNNSettings)this.settings).k_max);
    }

    @Override
    protected void initializeCapacities(RdKNNEntry exampleLeaf) {
        int dimensionality = exampleLeaf.getDimensionality();
        int distanceSize = 8;
        double overhead = 16.125;
        if ((double)this.getPageSize() - overhead < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)(((double)this.getPageSize() - overhead) / (double)(4 + 16 * dimensionality + distanceSize)) + 1;
        if (this.dirCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1));
        }
        this.dirMinimum = (int)Math.round((double)(this.dirCapacity - 1) * 0.5);
        if (this.dirMinimum < 2) {
            this.dirMinimum = 2;
        }
        this.leafCapacity = (int)(((double)this.getPageSize() - overhead) / (double)(4 + 8 * dimensionality + distanceSize)) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1));
        }
        this.leafMinimum = (int)Math.round((double)(this.leafCapacity - 1) * 0.5);
        if (this.leafMinimum < 2) {
            this.leafMinimum = 2;
        }
        if (LOG.isVerbose()) {
            LOG.verbose("Directory Capacity: " + this.dirCapacity + "\nLeaf Capacity: " + this.leafCapacity);
        }
    }

    protected List<DoubleObjPair<RdKNNEntry>> getSortedEntries(AbstractRStarTreeNode<?, ?> node, SpatialComparable q, SpatialPrimitiveDistanceFunction<?> distanceFunction) {
        ArrayList<DoubleObjPair<RdKNNEntry>> result = new ArrayList<DoubleObjPair<RdKNNEntry>>();
        for (int i = 0; i < node.getNumEntries(); ++i) {
            RdKNNEntry entry = (RdKNNEntry)node.getEntry(i);
            double minDist = distanceFunction.minDist(entry, q);
            result.add(new DoubleObjPair<RdKNNEntry>(minDist, entry));
        }
        Collections.sort(result);
        return result;
    }

    private void preInsert(RdKNNEntry q, RdKNNEntry nodeEntry, KNNHeap knns_q) {
        double knnDist_q = knns_q.getKNNDistance();
        RdKNNNode node = (RdKNNNode)this.getNode(nodeEntry);
        double knnDist_node = 0.0;
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNLeafEntry p = (RdKNNLeafEntry)node.getEntry(i);
                double dist_pq = this.distanceQuery.distance((DBIDRef)p.getDBID(), (DBIDRef)((LeafEntry)((Object)q)).getDBID());
                if (dist_pq <= knnDist_q) {
                    knns_q.insert(dist_pq, p.getDBID());
                    if (knns_q.size() >= ((RdkNNSettings)this.settings).k_max) {
                        knnDist_q = knns_q.getKNNDistance();
                        q.setKnnDistance(knnDist_q);
                    }
                }
                if (dist_pq <= p.getKnnDistance()) {
                    KNNList knns_without_q = this.knnQuery.getKNNForObject(this.relation.get(p.getDBID()), ((RdkNNSettings)this.settings).k_max);
                    p.setKnnDistance(knns_without_q.size() + 1 < ((RdkNNSettings)this.settings).k_max ? Double.NaN : Math.min(knns_without_q.doubleValue(knns_without_q.size() - 1), dist_pq));
                }
                knnDist_node = Math.max(knnDist_node, p.getKnnDistance());
            }
        } else {
            NumberVector obj = (NumberVector)this.relation.get(((LeafEntry)((Object)q)).getDBID());
            List<DoubleObjPair<RdKNNEntry>> entries = this.getSortedEntries(node, obj, ((RdkNNSettings)this.settings).distanceFunction);
            for (DoubleObjPair<RdKNNEntry> distEntry : entries) {
                RdKNNEntry entry = (RdKNNEntry)distEntry.second;
                double entry_knnDist = entry.getKnnDistance();
                if (distEntry.first < entry_knnDist || distEntry.first < knnDist_q) {
                    this.preInsert(q, entry, knns_q);
                    knnDist_q = knns_q.getKNNDistance();
                }
                knnDist_node = Math.max(knnDist_node, entry.getKnnDistance());
            }
        }
        nodeEntry.setKnnDistance(knnDist_node);
    }

    private void doReverseKNN(RdKNNNode node, DBID oid, ModifiableDoubleDBIDList result) {
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNLeafEntry entry = (RdKNNLeafEntry)node.getEntry(i);
                double distance = this.distanceQuery.distance((DBIDRef)entry.getDBID(), (DBIDRef)oid);
                if (!(distance <= entry.getKnnDistance())) continue;
                result.add(distance, entry.getDBID());
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNDirectoryEntry entry = (RdKNNDirectoryEntry)node.getEntry(i);
                double minDist = this.distanceQuery.minDist((SpatialComparable)entry, oid);
                if (!(minDist <= entry.getKnnDistance())) continue;
                this.doReverseKNN((RdKNNNode)this.getNode(entry), oid, result);
            }
        }
    }

    private void doBulkReverseKNN(RdKNNNode node, DBIDs ids, Map<DBID, ModifiableDoubleDBIDList> result) {
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNLeafEntry entry = (RdKNNLeafEntry)node.getEntry(i);
                DBIDIter iter = ids.iter();
                while (iter.valid()) {
                    DBID id = DBIDUtil.deref(iter);
                    double distance = this.distanceQuery.distance((DBIDRef)entry.getDBID(), (DBIDRef)id);
                    if (distance <= entry.getKnnDistance()) {
                        result.get(id).add(distance, entry.getDBID());
                    }
                    iter.advance();
                }
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNDirectoryEntry entry = (RdKNNDirectoryEntry)node.getEntry(i);
                ArrayModifiableDBIDs candidates = DBIDUtil.newArray();
                DBIDIter iter = ids.iter();
                while (iter.valid()) {
                    DBID id = DBIDUtil.deref(iter);
                    double minDist = this.distanceQuery.minDist((SpatialComparable)entry, id);
                    if (minDist <= entry.getKnnDistance()) {
                        candidates.add(id);
                    }
                    if (!candidates.isEmpty()) {
                        this.doBulkReverseKNN((RdKNNNode)this.getNode(entry), candidates, result);
                    }
                    iter.advance();
                }
            }
        }
    }

    private void adjustKNNDistance(RdKNNEntry entry, ArrayDBIDs ids, List<? extends KNNList> knnLists) {
        RdKNNNode node = (RdKNNNode)this.getNode(entry);
        double knnDist_node = 0.0;
        if (node.isLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNEntry leafEntry = (RdKNNEntry)node.getEntry(i);
                DBID id = ((LeafEntry)((Object)leafEntry)).getDBID();
                int pos = ids.binarySearch(id);
                if (pos >= 0) {
                    leafEntry.setKnnDistance(knnLists.get(pos).getKNNDistance());
                }
                knnDist_node = Math.max(knnDist_node, leafEntry.getKnnDistance());
            }
        } else {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                RdKNNEntry dirEntry = (RdKNNEntry)node.getEntry(i);
                this.adjustKNNDistance(dirEntry, ids, knnLists);
                knnDist_node = Math.max(knnDist_node, dirEntry.getKnnDistance());
            }
        }
        entry.setKnnDistance(knnDist_node);
    }

    @Override
    protected RdKNNNode createNewLeafNode() {
        return new RdKNNNode(this.leafCapacity, true);
    }

    @Override
    protected RdKNNNode createNewDirectoryNode() {
        return new RdKNNNode(this.dirCapacity, false);
    }

    @Override
    protected RdKNNEntry createNewDirectoryEntry(RdKNNNode node) {
        return new RdKNNDirectoryEntry(node.getPageID(), node.computeMBR(), node.kNNDistance());
    }

    @Override
    protected RdKNNEntry createRootEntry() {
        return new RdKNNDirectoryEntry(0, null, Double.NaN);
    }

    private void checkDistanceFunction(SpatialPrimitiveDistanceFunction<? super O> distanceFunction) {
        if (!((RdkNNSettings)this.settings).distanceFunction.equals(distanceFunction)) {
            throw new IllegalArgumentException("Parameter distanceFunction must be an instance of " + this.distanceQuery.getClass() + ", but is " + distanceFunction.getClass());
        }
    }

    protected RdKNNLeafEntry createNewLeafEntry(DBID id) {
        return new RdKNNLeafEntry(id, (NumberVector)this.relation.get(id), Double.NaN);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public final void insert(DBIDRef id) {
        this.insertLeaf(this.createNewLeafEntry(DBIDUtil.deref(id)));
    }

    @Override
    public final void insertAll(DBIDs ids) {
        if (ids.isEmpty() || ids.size() == 1) {
            return;
        }
        if (this.canBulkLoad()) {
            ArrayList<RdKNNEntry> leafs = new ArrayList<RdKNNEntry>(ids.size());
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                leafs.add(this.createNewLeafEntry(DBIDUtil.deref(iter)));
                iter.advance();
            }
            this.bulkLoad((List<RdKNNEntry>)leafs);
        } else {
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                this.insert(iter);
                iter.advance();
            }
        }
        this.doExtraIntegrityChecks();
    }

    @Override
    public final boolean delete(DBIDRef id) {
        NumberVector obj = (NumberVector)this.relation.get(id);
        IndexTreePath deletionPath = this.findPathToObject(this.getRootPath(), obj, id);
        if (deletionPath == null) {
            return false;
        }
        this.deletePath(deletionPath);
        return true;
    }

    @Override
    public void deleteAll(DBIDs ids) {
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.delete(DBIDUtil.deref(iter));
            iter.advance();
        }
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        return RStarTreeUtil.getRangeQuery(this, (SpatialDistanceQuery)distanceQuery, hints);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        return RStarTreeUtil.getKNNQuery(this, (SpatialDistanceQuery)distanceQuery, hints);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        return null;
    }

    @Override
    public String getLongName() {
        return "RdKNNTree";
    }

    @Override
    public String getShortName() {
        return "rdknntree";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

